% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R, R/InitWtErgmTerm.R
\name{b1sociality-ergmTerm}
\alias{b1sociality-ergmTerm}
\alias{InitErgmTerm.b1sociality}
\alias{InitWtErgmTerm.b1sociality}
\title{Degree}
\usage{
# binary: b1sociality(nodes=-1)

# valued: b1sociality(nodes=-1, form="sum")
}
\arguments{
\item{nodes}{By default, \code{nodes=-1} means that the statistic for the
first node (in the second bipartition) will be omitted, but this argument may be changed to control
which statistics are included. The \code{nodes} argument is interpreted using the new UI for level specification
(see Specifying Vertex Attributes and Levels (\code{?nodal_attributes}) for details), where both the attribute and the sorted
unique values are the vector of vertex indices \code{(nb1 + 1):n} , where
\code{nb1} is the size of the first bipartition and \code{n} is the total number of nodes in the network. Thus \code{nodes=120} will include only the statistic
for the 120th node in the second biparition, while \code{nodes=I(120)} will include only the statistic for the 120th node in the entire network.}

\item{form}{character how to aggregate tie values in a valued ERGM}
}
\description{
This term adds one network statistic for each node in the first bipartition, equal to the number of
ties of that node. This term can only be used with bipartite networks. For directed networks, see \code{sender} and
\code{receiver}. For unipartite networks, see \code{sociality}.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "b1sociality", "subsection")}
}
\concept{bipartite}
\concept{dyad-independent}
\concept{undirected}
