% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.operator.R
\name{ergm_symmetrize}
\alias{ergm_symmetrize}
\alias{ergm_symmetrize.default}
\alias{ergm_symmetrize.network}
\title{Return a symmetrized version of a binary network}
\usage{
ergm_symmetrize(x, rule = c("weak", "strong", "upper", "lower"), ...)

\method{ergm_symmetrize}{default}(x, rule = c("weak", "strong", "upper", "lower"), ...)

\method{ergm_symmetrize}{network}(x, rule = c("weak", "strong", "upper", "lower"), ...)
}
\arguments{
\item{x}{an object representing a network.}

\item{rule}{a string specifying how the network is to be
symmetrized; see \code{\link[sna:symmetrize]{sna::symmetrize()}} for details; for the
\code{\link{network}} method, it can also be a function or a list; see
Details.}

\item{...}{additional arguments to \code{\link[sna:symmetrize]{sna::symmetrize()}}.}
}
\description{
Return a symmetrized version of a binary network
}
\details{
The \code{\link{network}} method requires more flexibility, in order
to specify how the edge attributes are handled. Therefore, \code{rule}
can be one of the following types: \describe{

\item{a character vector}{The string is interpreted as in
\code{\link[sna:symmetrize]{sna::symmetrize()}}. For edge attributes, \code{"weak"} takes the
maximum value and \code{"strong"} takes the minimum
value" for ordered attributes, and drops the unordered.}

\item{a function}{ The function is evaluated on a \code{\link{data.frame}}
constructed by joining (via \code{\link[=merge]{merge()}}) the edge \code{\link{tibble}} with all
attributes and \code{NA} indicators with itself reversing tail and head
columns, and appending original columns with \code{".th"} and the
reversed columns with \code{".ht"}. It is then evaluated for each
attribute in turn, given two arguments: the data frame and the name
of the attribute.}

\item{a list}{The list must have exactly one unnamed element, and
the remaining elements must be named with the names of edge
attributes. The elements of the list are interpreted as above,
allowing each edge attribute to be handled differently. Unnamed
arguments are dropped. }

}
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: The default method, passing the input on to \code{\link[sna:symmetrize]{sna::symmetrize()}}.

\item \code{network}: A method for \code{\link{network}} objects, which preserves network and vertex attributes, and handles edge attributes.
}}

\note{
This was originally exported as a generic to overwrite
\code{\link[sna:symmetrize]{sna::symmetrize()}}. By developer's request, it has been renamed;
eventually, \code{sna} or \code{network} packages will export the generic
instead.
}
\examples{
data(sampson)
samplike[1,2] <- NA
samplike[4.1] <- NA
sm <- as.matrix(samplike)

tst <- function(x,y){
  mapply(identical, x, y)
}

stopifnot(all(tst(as.logical(as.matrix(ergm_symmetrize(samplike, "weak"))), sm | t(sm))),
          all(tst(as.logical(as.matrix(ergm_symmetrize(samplike, "strong"))), sm & t(sm))),
          all(tst(c(as.matrix(ergm_symmetrize(samplike, "upper"))),
                  sm[cbind(c(pmin(row(sm),col(sm))),c(pmax(row(sm),col(sm))))])),
          all(tst(c(as.matrix(ergm_symmetrize(samplike, "lower"))),
                  sm[cbind(c(pmax(row(sm),col(sm))),c(pmin(row(sm),col(sm))))])))
}
