% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm_proposal.R
\name{ergm_proposal_table}
\alias{ergm_proposal_table}
\title{Table mapping reference,constraints, etc. to ERGM Metropolis-Hastings proposals}
\usage{
ergm_proposal_table(Class, Reference, Constraints, Priority, Weights,
  Proposal)
}
\arguments{
\item{Class}{default to "c"}

\item{Reference}{The reference measure used in the model. For the list of
reference measures, see \code{\link{ergm-references}}}

\item{Constraints}{The constraints used in the model. For the list of
constraints, see \code{\link{ergm-constraints}}}

\item{Priority}{On existence of multiple qualifying proposals, specifies the
priority (\code{-1},\code{0},\code{1}, etc.) of proposals to be used.}

\item{Weights}{The sampling weights on selecting toggles (random, TNT, etc).}

\item{Proposal}{The matching proposal from the previous arguments.}
}
\description{
This is a low-level function not intended to be called directly by
end users. For information on Metropolis-Hastings proposal methods,
\link{ergm-proposals}. This function sets up the table mapping
constraints, references, etc. to \code{ergm_proposals}. Calling it with
arguments adds a new row to this table. Calling it without
arguments returns the table so far.
}
\note{
The arguments \code{Class}, \code{Reference}, and \code{Constraints} can
have length greater than 1. If this is the case, the rows added
to the table are a \emph{Cartesian product} of their elements.
}
