% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlebdm.R
\name{rlebdm}
\alias{rlebdm}
\alias{as.rlebdm}
\alias{as.rlebdm.matrix}
\alias{as.rlebdm.edgelist}
\alias{as.rlebdm.network}
\alias{as.matrix.rlebdm}
\alias{dim.rlebdm}
\alias{print.rlebdm}
\alias{!.rlebdm}
\alias{|.rlebdm}
\alias{&.rlebdm}
\alias{<.rlebdm}
\alias{>.rlebdm}
\alias{<=.rlebdm}
\alias{>=.rlebdm}
\alias{==.rlebdm}
\alias{!=.rlebdm}
\alias{as.edgelist.rlebdm}
\title{RLE-Compressed Boolean Dyad Matrix}
\usage{
rlebdm(x, n)

as.rlebdm(x, ...)

\method{as.rlebdm}{matrix}(x, ...)

\method{as.rlebdm}{edgelist}(x, ...)

\method{as.rlebdm}{network}(x, ...)

\method{as.matrix}{rlebdm}(x, ...)

\method{dim}{rlebdm}(x)

\method{print}{rlebdm}(x, compact = TRUE, ...)

\method{!}{rlebdm}(x)

\method{|}{rlebdm}(e1, e2)

\method{&}{rlebdm}(e1, e2)

\method{<}{rlebdm}(e1, e2)

\method{>}{rlebdm}(e1, e2)

\method{<=}{rlebdm}(e1, e2)

\method{>=}{rlebdm}(e1, e2)

\method{==}{rlebdm}(e1, e2)

\method{!=}{rlebdm}(e1, e2)

\method{as.edgelist}{rlebdm}(x, prototype = NULL, ...)
}
\arguments{
\item{x}{for \code{\link[=rlebdm]{rlebdm()}}, an \code{\link[=rle]{rle()}} object or a vector that is converted to one; it will be coerced to \code{\link[=logical]{logical()}} before processing; for \code{\link[=as.rlebdm.matrix]{as.rlebdm.matrix()}}, a matrix.}

\item{n}{the dimensions of the square matrix represented.}

\item{...}{additional arguments, currently unused.}

\item{compact}{whether to print the matrix compactly (dots and stars) or to print it as a logical matrix.}

\item{e1, e2}{arguments to the binary operations.}

\item{prototype}{an optional network with network attributes that
are transferred to the edgelist and will filter it (e.g., if the
prototype network is given and does not allow self-loops, the
edgelist will not have self-loops either,e ven if the dyad matrix
has non-\code{FALSE} diagonal).}
}
\description{
A simple class representing boolean (logical) square matrix
run-length encoded in a column-major order.
}
\section{Methods (by generic)}{
\itemize{
\item \code{as.rlebdm}: Convert a square matrix of mode coercible to \code{\link{logical}} to an
\code{\link{rlebdm}}.

\item \code{as.rlebdm}: Convert an object of class \code{\link{edgelist}} to an \code{\link{rlebdm}} object
whose cells in the edge list are set to \code{TRUE} and whose other
cells are set to \code{FALSE}.

\item \code{as.rlebdm}: Convert an object of class \code{\link{network}} to an \code{\link{rlebdm}} object
whose cells corresponding to extant edges are set to \code{TRUE} and
whose other cells are set to \code{FALSE}.

\item \code{as.edgelist}: Convert an \code{\link{rlebdm}} object to an \code{\link{edgelist}}: a two-column
integer matrix giving the cells with \code{TRUE} values.
}}

\examples{
# From a vector
rlebdm(rep(rep(c(0,1),each=3),14)[seq_len(81)], 9)

# From a constant
rlebdm(1, 3)

# Large matrix (overflowing .Machine$integer.max)
big <- rlebdm(1, 50000)
unclass(big) # Represented as two runs
stopifnot(length(big)==50000^2)

}
\seealso{
\code{\link[=as.rlebdm.ergm_conlist]{as.rlebdm.ergm_conlist()}}
}
\keyword{internal}
