#' sim_panel_data for the erfe package
#'
#' Simulated toy data that comes with the erfe package.
#' The dataset is generated according to a location-shift Gaussian model
#' which corresponds to  model I of the manuscript simulation section.
#' The dataset is a balanced panel with 50 units and 5 within observations.
#' The dataset has 6 variables: id, pred1, pred2, resp, nobs, and year.
#' The variable id is the unit's ids, pred1 and pred2 are the main regressors.
#' The response variable is generated by two regressors (pred1 and pred2),
#' and one fixed-effect and a Gaussian error. The variable nobs is the number
#' of units and year is the panel number.
#' @docType data
#' @usage data(sim_panel_data)
#'
#' @format An object of class \code{"data.frame"}
#' \describe{
#'  \item{id}{The variable id is the unit's ids.}
#'  \item{pred1}{The first regressor.}
#'  \item{pred2}{The second regressor.}
#'  \item{resp}{The response variable.}
#'  \item{nobs}{The number of units.}
#'  \item{year}{The time ou panel variable.}
#' }
#' @references This data set was artificially created for the erfe package.
#' @keywords datasets
#' 
#' @examples
#' data(sim_panel_data)
"sim_panel_data"

