% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-yr.R
\name{is_yr}
\alias{is_yr}
\alias{validate_yr}
\alias{is_valid_yr}
\title{Validation functions for \code{yr} objects}
\usage{
is_yr(x)

validate_yr(x)

is_valid_yr(x)
}
\arguments{
\item{x}{Object to test.}
}
\value{
\code{is_yr()} and \code{is_valid_yr()} return \code{TRUE} or \code{FALSE}.
\code{validate_yr()} returns \code{x} invisibly, and is used for its side-effect of
throwing an informative error for invalid objects.
}
\description{
Tests whether an object is a vector of years with an era (a \code{yr} object).
\code{is_yr()} tests whether the object inherits from the S3 class \code{era_yr}.
\code{is_valid_yr()} performs additional checks to determine whether the object
is well-formed (see details).
\code{validate_yr()} throws an informative error message for invalid \code{yr}s.
}
\details{
Valid \code{yr} objects:
\itemize{
\item Must contain numeric data (NAs are allowed)
\item Must have the \code{era} attribute set and not NA
\item Must not have more than one era
\item Must have an \code{era} attribute that is a valid era object (see \code{validate_era()})
}
}
\examples{
x <- yr(5000:5050, era("cal BP"))
is_yr(x)
is_valid_yr(x)
validate_yr(x)
}
\seealso{
Other era helper functions: 
\code{\link{era_parameters}},
\code{\link{era_year_parameters}},
\code{\link{era_year}},
\code{\link{era}},
\code{\link{is_era_year}()},
\code{\link{is_era}()},
\code{\link{this_year}()}
}
\concept{era helper functions}
