% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/era_year.R
\name{era_year_parameters}
\alias{era_year_parameters}
\alias{era_year_label}
\alias{era_year_days}
\title{Get the parameters of an \code{era_year} object.}
\usage{
era_year_label(x)

era_year_days(x)
}
\arguments{
\item{x}{An object of class \code{era_year}.}
}
\value{
Value of the parameter.
}
\description{
Extracts a specific parameter from a year unit object constructed by
\code{\link[=era_year]{era_year()}}.
}
\examples{
julian <- era_year("Julian", 365.25)
era_year_label(julian)
era_year_days(julian)
}
\seealso{
Other era helper functions: 
\code{\link{era_parameters}},
\code{\link{era_year}()},
\code{\link{era}()},
\code{\link{is_era_year}()},
\code{\link{is_era}()},
\code{\link{is_yr}()},
\code{\link{this_year}()}
}
\concept{era helper functions}
