% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqshannon.R
\name{shannon}
\alias{shannon}
\title{Calculate Shannon's Index}
\usage{
shannon(
  scores,
  version = NULL,
  by.dimension = TRUE,
  ignore.invalid = TRUE,
  dimensions = .getDimensionNames(),
  base = 2,
  digits = 2,
  permutations = TRUE
)
}
\arguments{
\item{scores}{data.frame, numeric or character. For data.frame default column 
names should be MO, SC, UA, PD and AD representing Mobility, Self-care, 
Usual activities, Pain/discomfort and Anxiety/depression. Vector using five 
digit format can also be used.}

\item{version}{string of value "3L" or "5L" to indicate instrument version.}

\item{by.dimension}{boolean whether to calculate scores by EQ-5D dimensions 
or for the whole dataset. Defaults to TRUE.}

\item{ignore.invalid}{boolean whether to ignore invalid scores. TRUE returns NA, FALSE 
throws an error.}

\item{dimensions}{character vector, specifying "dimension" column names. Defaults 
are "MO", "SC", "UA", "PD" and "AD".}

\item{base}{numeric base of logarithm to use. Defaults to base 2.}

\item{digits}{numeric specifying the number of decimal places. Defaults to 2.}

\item{permutations}{boolean whether to use maximum number of permutations for 
H' max or the number of observed unique profiles. Default is TRUE.}
}
\value{
a single list or list of dimensions containing H' H' max and J' scores.
}
\description{
Calculate Shannon's H' (diversity) index, H' max and Shannon's J' (evenness) 
index for an EQ-5D data set. This can be calculated both by dimension and 
for health states as a whole.
}
\examples{
dat <- read.csv(system.file("extdata", "eq5d3l_example.csv", package="eq5d"))

shannon(dat, version="3L", by.dimension=FALSE)
shannon(dat, version="3L", by.dimension=TRUE)

}
