% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord.R
\name{match_coord}
\alias{match_coord}
\title{Match coordinates of input EPW in the CMIP6 output file database}
\usage{
match_coord(epw, threshold = list(lon = 1, lat = 1), max_num = NULL)
}
\arguments{
\item{epw}{Possible values:
\itemize{
\item A file path of EPW file
\item An \link[eplusr:Epw]{eplusr::Epw} object
\item A regular expression used to search locations in EnergyPlus Weather
Database, e.g. "los angeles.*tmy3". You will be asked to select a matched
EPW to download and read. It will be saved into \code{\link[=tempdir]{tempdir()}}. Note that the
search is case-insensitive
}}

\item{threshold}{A list of 2 elements \code{lon} and \code{lat} specifying the
absolute distance threshold used when matching longitude and latitude.
Default: \code{list(lon = 1.0, lat = 1.0)}}

\item{max_num}{The maximum number to be matched for both longitude and
latitude when \code{threshold} is matched. Default is \code{NULL}, which means
no limit}
}
\value{
An \code{epw_cmip6_coord} object, which is basically a list of 3 elements:
\itemize{
\item \code{epw}: An \link[eplusr:Epw]{eplusr::Epw} object parsed from input \code{epw} argument
\item \code{meta}: A list containing basic meta data of input EPW, including \code{city},
\code{state_province}, \code{country}, \code{latitute} and \code{longitude}.
\item \code{coord}: A \code{\link[data.table:data.table]{data.table::data.table()}} which is basically CMIP6 index
database with an appending new list column \code{coord} that contains
matched latitudes and longitudes in each NetCDF file. Each element
in \code{coord} contains 2 elements \code{lat} and \code{lon}, in which contains
the 4 components describing the matched coordinates.
\itemize{
\item \code{index}: the indices of matched coordinates
\item \code{value}: the actual longitude or latitude in the NetCDF coordinate
grids
\item \code{dis}: the distance between the coordinate values in NetCDF and input
EPW
\item \code{which}: The value indices of longitude or latitude in the NetCDF
coordinate grids. These values are used to extract the corresponding
variable values
}
}
}
\description{
\code{match_coord()} takes an EPW and uses its longitude and latitude to match
corresponding values that meet specified threshold in NetCDF files.
}
\details{
\code{match_coord()} uses \link[future.apply:future_lapply]{future.apply}
underneath. You can use your preferable \link[future:plan]{future} backend to
speed up data extraction in parallel. By default, \code{match_coord()} uses
\link[future:sequential]{future::sequential} backend, which runs things in sequential.
}
\examples{
\dontrun{
# download an EPW from EnergyPlus website
epw <- eplusr::download_weather("los angeles.*TMY3", dir = tempdir(),
    type = "EPW", ask = FALSE)

match_coord(epw, threshold = list(lon = 1.0, lat = 1.0))
}

}
