## -----------------------------------------------------------------------------
library(epuR)
library(dygraphs)
all_data <- get_EPU()
dygraph(all_data)

## -----------------------------------------------------------------------------
dygraph(all_data)

## -----------------------------------------------------------------------------
china_epu <- get_EPU(region = "China")
dygraph(china_epu)

## -----------------------------------------------------------------------------
china_data <- all_data$China
dygraph(china_data)

## -----------------------------------------------------------------------------
dygraph(na.omit(china_data))

## -----------------------------------------------------------------------------
us_tpu <- get_TPU(region = "US")
dygraph(us_tpu)

## -----------------------------------------------------------------------------
china_tpu <- get_TPU("China")
dygraph(china_tpu)

## -----------------------------------------------------------------------------
jap_tpu <- get_TPU("Japan")
dygraph(jap_tpu)

## -----------------------------------------------------------------------------
dygraph(jap_tpu$TPU)

## -----------------------------------------------------------------------------
emv_data <- get_EMV(all = F)
dygraph(emv_data)

## -----------------------------------------------------------------------------
wui_overall <- get_WUI("F1")
dygraph(wui_overall)

## -----------------------------------------------------------------------------
wtui_data <- get_WUI("T8")
dygraph(wtui_data$CHN)

## -----------------------------------------------------------------------------
fsi_mon <- get_FSI()
dygraph(fsi_mon)
fsi_quar <- get_FSI(freq = "quarterly")
dygraph(fsi_quar)

## -----------------------------------------------------------------------------
usa_iri <- get_IRI("USA")
dygraph(usa_iri)

## -----------------------------------------------------------------------------
gpr <- get_GPR(type = 1)
dygraph(gpr$GPR)

