% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeNeuroTable.R
\name{createDashVectorForATC}
\alias{createDashVectorForATC}
\title{Creates a vector with an X at each position where a drug from the druglist matches the ATC class list slatc}
\usage{
createDashVectorForATC(druglist, atchashda, atchashsec, slatc)
}
\arguments{
\item{druglist}{list of drug names}

\item{atchashda}{hashmap retrieved from readAtcMapIntoHashMapDrugNamesAtcCodes}

\item{atchashsec}{hashmap retrieved from readSecondLevelATC}

\item{slatc}{list of ATC classes}
}
\value{
list with crosses if the drug in druglist matches at the position of the ATC class in slatc
}
\description{
Creates a vector with an X at each position where a drug from the druglist matches the ATC class list slatc
}
\examples{
\dontrun{
createDashVectorForATC(druglist, atchashda, atchashsec, slatc)
}
}
