#' List of frequency named by drug terms that co-occur with the EpSO ontology in the 
#' corpus of LIVIVO.
#'
#' @source The source data to create the ranked lists of drug names is produced using 
#' the text mining workflows described in Mueller, Bernd and Hagelstein, Alexandra (2016) 
#' <doi:10.4126/FRL01-006408558> and Mueller, Bernd et al. (2017) 
#' <doi:10.1007/978-3-319-58694-6_22>. The moment of execution for generating the data 
#' on the corpus of LIVIVO is June 26th 2018.
#' @format A named list of drug term frequencies
#' @examples
#' utils::data(rawDrugBankCoOcEpSO, package="epos")
"rawDrugBankCoOcEpSO"

#' List of frequency named by drug terms that co-occur with the ESSO ontology in the 
#' corpus of LIVIVO.
#'
#' @source The source data to create the ranked lists of drug names is produced using 
#' the text mining workflows described in Mueller, Bernd and Hagelstein, Alexandra (2016) 
#' <doi:10.4126/FRL01-006408558> and Mueller, Bernd et al. (2017) 
#' <doi:10.1007/978-3-319-58694-6_22>. The moment of execution for generating the data 
#' on the corpus of LIVIVO is June 26th 2018.
#' @format A named list of drug term frequencies
#' @examples
#' utils::data(rawDrugBankCoOcESSO, package="epos")
"rawDrugBankCoOcESSO"

#' List of frequency named by drug terms that co-occur with the EPILONT ontology in the 
#' corpus of LIVIVO.
#'
#' @source The source data to create the ranked lists of drug names is produced using 
#' the text mining workflows described in Mueller, Bernd and Hagelstein, Alexandra (2016) 
#' <doi:10.4126/FRL01-006408558> and Mueller, Bernd et al. (2017) 
#' <doi:10.1007/978-3-319-58694-6_22>. The moment of execution for generating the data 
#' on the corpus of LIVIVO is June 26th 2018.
#' @format A named list of drug term frequencies
#' @examples
#' utils::data(rawDrugBankCoOcEPILONT, package="epos")
"rawDrugBankCoOcEPILONT"