% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spark-bridge.R
\name{download_dependencies}
\alias{download_dependencies}
\title{Updates Java dependencies}
\usage{
download_dependencies(tasks = get_tasks())
}
\arguments{
\item{tasks}{Task object for reporting progress and error messages, default: get_tasks()}
}
\value{
The list of tasks updated with produced messages
}
\description{
Download Java dependencies of the application mainly related to Apache SPARK and Lucene,
}
\details{
Run a one-shot task consisting of downloading Java and Scala dependencies, this is separated by the following subtasks
\itemize{
  \item{Download jar dependencies from configuration maven repo to project data folder. This includes, scala, spark, lucene. Packages to be downloaded are defined in package file 'sbt-deps.txt'}
  \item{Download winutils from configuration URL to project data folder. For more details on winutils please see 
    \url{https://issues.apache.org/jira/browse/HADOOP-13223} and \url{https://issues.apache.org/jira/browse/HADOOP-16816}
  }
}

The URLs to download the JAR dependencies (maven package manager) and Winutils are on the configuration tab of the Shiny app.

Normally this function is not called directly by the user but from the \code{\link{detect_loop}} function.
}
\examples{
if(FALSE){
   library(epitweetr)
   # setting up the data folder
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())

   # geolocating last tweets
   tasks <- download_dependencies()
}
}
\seealso{
\code{\link{detect_loop}}

 \code{\link{get_tasks}}
}
