% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{aggregate_tweets}
\alias{aggregate_tweets}
\title{Execute the aggregation task}
\usage{
aggregate_tweets(
  series = list("country_counts", "geolocated", "topwords"),
  tasks = get_tasks()
)
}
\arguments{
\item{series}{List of series to aggregate, default: list("country_counts", "geolocated", "topwords")}

\item{tasks}{Current tasks for reporting purposes, default: get_tasks()}
}
\value{
the list of tasks updated with aggregate messages
}
\description{
Get all the tweets from the Twitter Standard Search API json files and the geolocated tweets json files obtained by calling (\code{\link{geotag_tweets}}) and store the results in the series folder as daily Rds files
}
\details{
This function will write new aggregated series by launching a SPARK task of aggregating data collected from the Twitter Search API and geolocated from geotag tweets. By doing the following steps:
- Identify the last aggregates date by looking into the series folder

- Look for date range of tweets collected since that day by looking at the stat json files produced by the search loop

- For each day that has to be updated a list of all geolocated and search files to load will be produced by looking at the stat files

- For each series passed as a parameter and for each date to update: 

 - a Spark task will be called that will deduplicate tweets for each topic, join them with geolocation information, and aggregate them to the required level and return to the standard output as json lines
 
 - the result of this task is parsed using jsonlite and saved into RDS files in the series folder
 
A prerequisite to this function is that the \code{\link{search_loop}} must have already collected tweets in the search folder and that geotag_tweets has already run.
Normally this function is not called directly by the user but from the \code{\link{detect_loop}} function.
}
\examples{
if(FALSE){
   library(epitweetr)
   # setting up the data folder
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())

   # aggregating all geolocated tweets collected since last aggregation for producing 
   # all time series
   aggregate_tweets()
}
}
\seealso{
\code{\link{detect_loop}}
 
 \code{\link{geotag_tweets}}
 
 \code{\link{generate_alerts}}
}
