% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo-tagging.R
\name{get_todays_sample_tweets}
\alias{get_todays_sample_tweets}
\title{Get a sample of latest tweet geolocations}
\usage{
get_todays_sample_tweets(limit = 1000, text_col = "text", lang_col = "lang")
}
\arguments{
\item{limit}{Size of the sample, default: 100}

\item{text_col}{Name of the tweet field to geolocate it should be one of the following ("text", "linked_text", "user_description", "user_location", "place_full_name", "linked_place_full_name"),
default: 'text'}

\item{lang_col}{Name of the tweet variable containing the language to evaluate. It should be one of the following ("lang", "linked_lang", NA), default: "lang"}
}
\value{
Dataframe containing the sampled tweets and the geolocation metrics
}
\description{
Get a sample of today's tweets for evaluation of geolocation threshold
}
\details{
This function will take a sample of tweets collected on the current date for testing the geolocation algorithm and giving the user the possibility to evaluate the optimal score.

In order for this function to work the search loop will have had to run on the current day and the tasks \code{\link{download_dependencies}}, 
\code{\link{update_geonames}} and \code{\link{update_languages}} will have had to successfully been run.
}
\examples{
if(FALSE){
   library(epitweetr)
   # setting up the data folder
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())

   # geolocating today's tweets
   show(get_todays_sample_tweets())
}
}
\seealso{
\code{\link{download_dependencies}}

 \code{\link{update_geonames}}

 \code{\link{update_languages}}

 \code{\link{geotag_tweets}}
}
