% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alert.R
\name{generate_alerts}
\alias{generate_alerts}
\title{Execute the alert task}
\usage{
generate_alerts(tasks = get_tasks())
}
\arguments{
\item{tasks}{current tasks for reporting purposes, default: get_tasks()}
}
\value{
The list of tasks updated with produced messages
}
\description{
Evaluate alerts for the last collected day for all topics and regions and send email alerts to subscribers
}
\details{
This function calculates alerts for the last aggregated day and then send emails to subscribers.

The alert calculation is based on the country_counts time series which stores alerts by country, hour and topics.

For each country and region the process starts by aggregating the last N days. A day is a block of consecutive 24 hours ending before the hour of the collected last tweet. 
N is defined by the alert baseline parameter on the configuration tab of the Shiny application (the default is N=7).

An alert will be produced when the number of tweets observed is above the threshold calculated by the modified version of the EARS algorithm (for more details see the package vignette). 
The behaviour of the alert detection algorithm is modified by the signal false positive rate (alpha), downweighting of previous alerts and weekly or daily baseline parameters 
as defined on the configuration tab of the Shiny application and the topics file.

A prerequisite to this function is that the \code{\link{search_loop}} must already have stored collected tweets in the search folder and that the geotagging and aggregation tasks have already been run.
Normally this function is not called directly by the user but from the \code{\link{detect_loop}} function.
}
\examples{
if(FALSE){
   library(epitweetr)
   # setting up the data folder
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())

   # calculating alerts for last day tweets and sending emails to subscriptors
   generate_alerts()
}
}
\seealso{
\code{\link{detect_loop}}
 
 \code{\link{geotag_tweets}}
 
 \code{\link{aggregate_tweets}}
}
