% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ode.R
\name{ratmak}
\alias{ratmak}
\title{Create 'ratmak' (Rational Mass Action Kinetics) object}
\usage{
ratmak(A, C, s = solver(), r1 = NULL, r2 = NULL, rx0 = reg("none", lower
  = 0, upper = Inf, fixed = TRUE))
}
\arguments{
\item{A}{The matrix of powers (bxd). Here d the number of species.}

\item{C}{The stoichiometric coefficient matrix (rxd). Here r is the number of reactions.}

\item{s}{\code{\link{solver}} object.}

\item{r1}{An object of class \code{\link{reg}} giving info about how to regularise and bound the first parameter. If not provided, the default one is used.}

\item{r2}{An object of class \code{\link{reg}} giving info about how to regularise and bound the second  parameters. If not provided, the default one is used.}

\item{rx0}{An object of class \code{\link{reg}} giving info about how to regularise and bound the initial state parameter. If not provided, the default one is used. This default \code{reg} sets \code{fixed = TRUE}, which is generally recommended.}
}
\value{
An object with S3 class "ratmak" and "ode".
}
\description{
This function creates an object of class \code{ratmak} (subclass of \code{ode}), which holds the basic information of the Rational Mass Action Kinetics system in question.
}
\details{
Rational Mass Action Kinetics is a class of ODE systems, having the following vector field:
\deqn{\frac{dx}{dt} = C^T * (\theta_1 * x^A) / (1 + \theta_2 * x^A)}
with \eqn{x^A = (\prod_{i=1}^dx_i^{A_{ji}})_{j=1}^b}, \eqn{\theta_1} and \eqn{\theta_2} estimatable parameter matrices of dimension rxb. \eqn{\theta_2} is restricted to non-negative values. The fraction is entry-wise. By convention the theta's will only be reported as vectors (concatinated column-wise).
}
\examples{
# Rational mass action kinetics
A <- matrix(
c(1, 0, 0, 0,
  0, 1, 2, 0,
  1, 0, 0, 1), ncol = 4, byrow = TRUE)
x0 <- c(X = 1, Y = 4, Z = 0.1, W = 0.1)
time <- seq(0, 1, by = .1)

rmak <- ratmak(A, diag(4))

# Solve system
numsolve(o = rmak, time = time, x0 = x0,
  param = list(theta1 = t(A * 1:3),
      theta2 = t((A + 1) * 3:1)))

# Evaluate field
field(rmak, x0,
  param = list(theta1 = t(A * 1:3),
      theta2 = t((A + 1) * 3:1)))

}
\seealso{
ode, numsolve, field
}
