% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ode.R
\name{ode}
\alias{ode}
\title{Abstract 'ode' object}
\usage{
ode(...)
}
\arguments{
\item{...}{Arguments passed to \code{\link{ode}}.}
}
\value{
An object with S3 class "ode".
}
\description{
The abstract class \code{ode}, which determines the ordinary differential equation system. Some systems have multiple parameter arguments (so far only \code{\link{ratmak}}). The bare \code{ode} class is abstract, hence in practice you need to use one of

\describe{
\item{\code{\link{mak}}}{Mass Action Kinetics reaction network system.}
\item{\code{\link{plk}}}{Power Law Kinetics system.}
\item{\code{\link{rlk}}}{Rational Law Kinetics system.}
\item{\code{\link{ratmak}}}{Rational Mass Action Kinetics.}
}

to create an actual \code{ode} object, which you can use.
}
\seealso{
mak, plk, rlk, ratmak
}
