% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probsens.irr.conf.R
\name{probsens.irr.conf}
\alias{probsens.irr.conf}
\title{Probabilistic sensitivity analysis for unmeasured confounding of person-time data and random error.}
\usage{
probsens.irr.conf(counts, pt = NULL, reps = 1000, prev.exp = list(dist =
  c("constant", "uniform", "triangular", "trapezoidal", "logit-logistic",
  "logit-normal"), parms = NULL), prev.nexp = list(dist = c("constant",
  "uniform", "triangular", "trapezoidal", "logit-logistic", "logit-normal"),
  parms = NULL), risk = list(dist = c("constant", "uniform", "triangular",
  "trapezoidal", "log-logistic", "log-normal"), parms = NULL), corr.p = NULL,
  alpha = 0.05, dec = 4, print = TRUE)
}
\arguments{
\item{counts}{A table or matrix where first row contains disease counts and second row contains person-time at risk, and first and second columns are exposed and unexposed observations, as:
\tabular{lll}{
\tab Exposed \tab Unexposed \cr
Cases \tab a \tab b \cr
Person-time \tab N1 \tab N0
}}

\item{pt}{A numeric vector of person-time at risk. If provided, \code{counts} must be a numeric vector of disease counts.}

\item{reps}{Number of replications to run.}

\item{prev.exp}{List defining the prevalence of exposure among the exposed. The first argument provides the probability distribution function (constant,uniform, triangular, trapezoidal, logit-logistic, or logit-normal) and the second its parameters as a vector:
\enumerate{
\item Constant; value,
\item Uniform: min, max,
\item Triangular: lower limit, upper limit, mode,
\item Trapezoidal: min, lower mode, upper mode, max.
\item Logit-logistic: location, scale, lower bound shift, upper bound shift,
\item Logit-normal: location, scale, lower bound shift, upper bound shift.
}}

\item{prev.nexp}{List defining the prevalence of exposure among the unexposed.}

\item{risk}{List defining the confounder-disease relative risk or the confounder-exposure odds ratio. The first argument provides the probability distribution function (constant,uniform, triangular, trapezoidal, log-logistic, or log-normal) and the second its parameters as a vector:
\enumerate{
\item Constant: value,
\item Uniform: min, max,
\item Triangular: lower limit, upper limit, mode,
\item Trapezoidal: min, lower mode, upper mode, max.
\item Log-logistic: location, scale,
\item Log-normal: location, scale.
}}

\item{corr.p}{Correlation between the exposure-specific confounder prevalences.}

\item{alpha}{Significance level.}

\item{dec}{Number of decimals in the printout.}

\item{print}{A logical scalar. Should the results be printed?}
}
\value{
A list with elements:
\item{obs.data}{The analysed 2 x 2 table from the observed data.}
\item{obs.measures}{A table of observed incidence rate ratio with exact confidence interval.}
\item{adj.measures}{A table of corrected incidence rate ratios.}
\item{sim.df}{Data frame of random parameters and computed values.}
}
\description{
Probabilistic sensitivity analysis to correct for unmeasured confounding when person-time data has been collected.
}
\examples{
set.seed(123)
# Unmeasured confounding
probsens.irr.conf(matrix(c(77, 10000, 87, 10000),
dimnames = list(c("D+", "Person-time"), c("E+", "E-")), ncol = 2),
reps = 20000,
prev.exp = list("trapezoidal", c(.01, .2, .3, .51)),
prev.nexp = list("trapezoidal", c(.09, .27, .35, .59)),
risk = list("trapezoidal", c(2, 2.5, 3.5, 4.5)),
corr.p = .8)
}
\references{
Lash, T.L., Fox, M.P, Fink, A.K., 2009 \emph{Applying Quantitative
Bias Analysis to Epidemiologic Data}, pp.117--150, Springer.
}

