% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.multi_epiparameter}
\alias{print.multi_epiparameter}
\title{Print method for \verb{<multi_epiparameter>} class}
\usage{
\method{print}{multi_epiparameter}(x, ..., n = NULL)
}
\arguments{
\item{x}{A \verb{<multi_epiparameter>} object.}

\item{...}{\link{dots} Extra arguments to be passed to the method.}

\item{n}{A \code{numeric} specifying how many \verb{<epiparameter>} objects to print.
This argument is passed to \code{\link[=head]{head()}} for \code{list} printing. Default is \code{NULL}
and the number of elements to print is controlled by package \code{\link[=options]{options()}}.}
}
\value{
Invisibly returns a \verb{<multi_epiparameter>}. Called for side-effects.
}
\description{
Print method for \verb{<multi_epiparameter>} class
}
\examples{
# entire database
db <- epiparameter_db()
db

# a single disease
db <- epiparameter_db(disease = "Ebola")
db

# a single epi parameter
db <- epiparameter_db(epi_name = "offspring distribution")
db
}
