% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.multi_epiparameter}
\alias{plot.multi_epiparameter}
\title{\code{\link[=plot]{plot()}} method for \verb{<multi_epiparameter>} class}
\usage{
\method{plot}{multi_epiparameter}(x, cumulative = FALSE, ...)
}
\arguments{
\item{x}{A \verb{<multi_epiparameter>} object.}

\item{cumulative}{A boolean \code{logical}, default is \code{FALSE}.
\code{cumulative = TRUE} plots the cumulative distribution function (CDF).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
These functions are invoked for their side effect of drawing
  on the active graphics device.
}
\description{
Plots a list of \verb{<epiparameter>} objects by overlaying their
distributions.
}
\details{
Unparameterised and discrete \verb{<epiparameter>} objects
are not plotted (see \code{\link[=is_parameterised]{is_parameterised()}} and \code{\link[=is_continuous]{is_continuous()}}).
}
\examples{
ebola_si <- epiparameter_db(disease = "Ebola", epi_name = "serial")
plot(ebola_si)
}
\author{
Joshua W. Lambert
}
