% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiparameter.R
\name{new_epiparameter}
\alias{new_epiparameter}
\title{Constructor for \verb{<epiparameter>} class}
\usage{
new_epiparameter(
  disease = character(),
  pathogen = character(),
  epi_name = character(),
  prob_distribution = list(),
  uncertainty = list(),
  summary_stats = list(),
  citation = character(),
  metadata = list(),
  method_assess = list(),
  notes = character(),
  auto_calc_params = logical(),
  ...
)
}
\arguments{
\item{disease}{A \code{character} string with name of the infectious disease.}

\item{pathogen}{A \code{character} string with the name of the causative agent of
disease, or \code{NA} if not known.}

\item{epi_name}{A \code{character} string with the name of the
epidemiological parameter type.}

\item{prob_distribution}{An S3 class containing the probability
distribution or a character string if the parameters of the probability
distribution are unknown but the name of the distribution is known, or \code{NA}
if the distribution name and parameters are unknown. Use
\code{\link[=create_prob_distribution]{create_prob_distribution()}} to create \code{prob_distribution}.}

\item{uncertainty}{A list of named vectors with the uncertainty around
the probability distribution parameters. If uncertainty around the parameter
estimates is unknown use \code{\link[=create_uncertainty]{create_uncertainty()}} (which is the
argument default) to create a list with the correct names with missing
values.}

\item{summary_stats}{A list of summary statistics, use
\code{\link[=create_summary_stats]{create_summary_stats()}} to create list. This list can include
summary statistics about the inferred distribution such as it's mean and
standard deviation, quantiles of the distribution, or information about the
data used to fit the distribution such as lower and upper range. The summary
statistics can also include uncertainty around metrics such as confidence
interval around mean and standard deviation.}

\item{citation}{A \verb{<bibentry>} with the citation of the source of the
data or the paper that inferred the distribution parameters, use
\code{\link[=create_citation]{create_citation()}} to create citation.}

\item{metadata}{A list of metadata, this can include: units, sample size,
the transmission mode of the disease (e.g. is it vector-borne or directly
transmitted), etc. It is assumed that the disease is not
vector-borne and that the distribution is intrinsic (e.g. not an extrinsic
delay distribution such as extrinsic incubation period) unless
\code{transmission_mode = "vector_borne"} is contained in the metadata. Use
\code{\link[=create_metadata]{create_metadata()}} to create metadata.}

\item{method_assess}{A list of methodological aspects used when fitting
the distribution, use \code{\link[=create_method_assess]{create_method_assess()}} to create method
assessment.}

\item{notes}{A \code{character} string with any additional information about the
data, inference method or disease.}

\item{auto_calc_params}{A boolean \code{logical} determining whether to try and
calculate the probability distribution parameters from summary statistics if
distribution parameters are not provided. Default is \code{TRUE}. In the case when
sufficient summary statistics are provided and the parameter(s) of the
distribution are not, the \code{\link[=.calc_dist_params]{.calc_dist_params()}} function is called to
calculate the parameters and add them to the \code{epiparameter} object created.}

\item{...}{\link{dots} Extra arguments to be passed to internal functions.

This is most commonly used to pass arguments to \code{\link[distcrete:distcrete]{distcrete::distcrete()}}
that construct the discretised distribution S3 object. To see which
arguments can be adjusted for discretised distributions see
\code{\link[distcrete:distcrete]{distcrete::distcrete()}}.}
}
\value{
An \verb{<epiparameter>} object.
}
\description{
Create an \verb{<epiparameter>} object. The
constructor will search whether parameters of the probability distribution
are supplied and if not look to see whether they can be inferred/extracted/
converted from summary statistics provided. It will also convert the
probability distribution (\code{prob_dist}) and its parameters
(\code{prob_dist_params}) into an S3 class, either a \code{distribution} object from
\code{{distributional}} when \code{discretise = FALSE}, or a \code{distcrete} object from
\code{{distcrete}} when \code{discretise = TRUE}.
}
\keyword{internal}
