% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addEffects.R
\name{addEffects}
\alias{addEffects}
\title{Attach additive effects to population.}
\usage{
addEffects(pop, effects = NULL, distrib = rnorm)
}
\arguments{
\item{pop}{an object of class \code{Population}.}

\item{effects}{an optional vector of additive effect coefficients.}

\item{distrib}{an optional random number generator function for a
distribution, defaulting to \code{\link{rnorm}}.}
}
\value{
A copy of the supplied \code{Population} object is returned, with
  additive effects attached.
}
\description{
Attach additive effects to a \code{Population} object.
}
\details{
\code{addEffects()} is a function for attaching additive effects to a given
population, ensuring that the initial additive variance is as given in the
population parameters.

If additive effect coefficients are directly supplied via the \code{effects}
vector, these may be scaled in order to comply with the initial additive
variance.
}
\examples{
# Create population
pop <- Population(
  popSize = 200, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100),
  broadH2 = 0.9, narrowh2 = 0.6, traitVar = 40
)

# Attach additive effects using a normal distribution
pop <- addEffects(pop)

# Attach additive effects using a uniform distribution
pop2 <- addEffects(pop, distrib = runif)

# Attach additive effects using a vector of coefficients
effects <- c(
  1.2, 1.5, -0.3, -1.4, 0.8,
  2.4, 0.2, -0.8, -0.4, 0.8,
  -0.2, -1.4, 1.4, 0.2, -0.9,
  0.4, -0.8, 0.0, -1.1, -1.3
)
pop3 <- addEffects(pop, effects = effects)

# Print first population
pop

# Print second population
pop2

# Print third population
pop3
}
\seealso{
\code{\link{Population}}, \code{\link{attachEpiNet}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
