% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unite_ci.R
\name{unite_ci}
\alias{unite_ci}
\alias{merge_ci_df}
\alias{merge_pci_df}
\title{Unite estimates and confidence intervals}
\usage{
unite_ci(
  x,
  col = NULL,
  ...,
  remove = TRUE,
  digits = 2,
  m100 = TRUE,
  percent = FALSE,
  ci = FALSE
)

merge_ci_df(x, e = 3, l = e + 1, u = e + 2, digits = 2)

merge_pci_df(x, e = 3, l = e + 1, u = e + 2, digits = 2)
}
\arguments{
\item{x}{a data frame with at least three columns defining an estimate, lower
bounds, and upper bounds.}

\item{col}{the quoted name of the replacement column to create}

\item{...}{three columns to bind together in the order of Estimate, Lower, and
Upper.}

\item{remove}{if \code{TRUE} (default), the three columns in \code{...} will be replaced by \code{col}}

\item{digits}{the number of digits to retain for the confidence interval.}

\item{m100}{\code{TRUE} if the result should be multiplied by 100}

\item{percent}{\code{TRUE} if the result should have a percent symbol added.}

\item{ci}{\code{TRUE} if the result should include "CI" within the braces (defaults to FALSE)}

\item{e}{the column of the estimate (defaults to the third column). Otherwise, a number}

\item{l}{the column of the lower bound (defaults to the fourth column). Otherwise, a number}

\item{u}{the column of the upper bound (defaults to the fifth column), otherwise, a number}
}
\value{
a modified data frame with merged columns or one additional column
representing the estimate and confidence interval
}
\description{
create a character column by combining estimate, lower and upper columns.
This is similar to \code{\link[tidyr:unite]{tidyr::unite()}}.
}
\examples{

fit <- lm(100/mpg ~ disp + hp + wt + am, data = mtcars)
df  <- data.frame(v = names(coef(fit)), e = coef(fit), confint(fit), row.names = NULL)
names(df) <- c("variable", "estimate", "lower", "upper")
print(df)
unite_ci(df, "slope (CI)", estimate, lower, upper, m100 = FALSE, percent = FALSE)

}
