% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectVariable.R
\name{selectVariable}
\alias{selectVariable}
\title{Select variables to keep or drop.}
\usage{
selectVariable(data = NULL, keep = NULL, drop = NULL)
}
\arguments{
\item{data}{a data frame in which variables are included.}

\item{keep}{a character vector specifying variables to keep.}

\item{drop}{a character vector specifying variables to drop.}
}
\value{
a data frame in which variables are kept or dropped.
}
\description{
Select variables to keep or drop and a data frame in which variables are kept or dropped is returned.
}
\examples{
df <- data.frame(id=seq(1,10), str=letters[1:10], fac=factor(seq(1,10)), stringsAsFactors=FALSE)
selectVariable(df, keep=c("id", "str"))
selectVariable(df, drop=c("fac"))
}

