% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertNA.R
\name{convertNA}
\alias{convertNA}
\title{Convert a character pattern or numeric value into NA and vice versa.}
\usage{
convertNA(data = NULL, na.character = c(""), na.numeric = NA,
  fromNA = FALSE)
}
\arguments{
\item{data}{a data.frame to summarize.}

\item{na.character}{a character vector specifying missing character.}

\item{na.numeric}{a numeric vector specifying missing value.}

\item{fromNA}{a logical value specifying replacement that NA is replaced with the first element of na.character or na.numeric.}
}
\value{
a data.frame with NA replacement.
}
\description{
Convert a character pattern or numeric value into NA and vice versa.
}
\examples{
dat <- data.frame(a=c("","2","3"),b=c("4", NA, "."), c=c(-1,1,3),
                  d=c(NA,3,2), stringsAsFactors=FALSE)
dat2 <- convertNA(dat, na.character=c("", "."))
dat3 <- convertNA(dat, na.character=".", na.numeric=-1, fromNA=TRUE)
dat
dat2
dat3
}
\seealso{
\code{\link{countNA}}
}

