% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/respeciate_generic.R
\name{respeciate_generic}
\alias{respeciate_generic}
\title{Respeciate unspecified samples}
\usage{
respeciate_generic(
  x,
  group_vars,
  species_col,
  date_col,
  window = c(0:Inf),
  .forceCopy = FALSE
)
}
\arguments{
\item{x}{a data.frame or data.table object}

\item{group_vars}{the minimum grouping set of variables for like samples in
a character vector; suggest c('patient_id','specimen_type','genus')}

\item{species_col}{a character containing the column with the organism species_col
name}

\item{date_col}{a character containing the column with the specimen/sample date_col}

\item{window}{an integer representing the number of days for which you will
allow a sample to be respeciated}

\item{.forceCopy}{default FALSE; TRUE will force data.table to take a copy
instead of editing the data without reference}
}
\value{
a data.table with a recharacterised \code{species_col} column
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Some samples within SGSS are submitted by laboratories as "GENUS SP" or
"GENUS UNNAMED". However, they may also have a fully identified sample taken
from the same site within a recent time period.  This function captures
species_col  from another sample within X-days of an unspeciated isolate.
}
\examples{
df <- data.frame(
ptid = c(round(runif(25,1,5))),
spec = sample(c("KLEBSIELLA SP",
                "KLEBSIELLA UNNAMED",
                "KLEBSIELLA PNEUMONIAE",
                "KLEBEIELLA OXYTOCA"),
              25,replace = TRUE),
type = "BLOOD",
specdate = sample(seq.Date(Sys.Date()-21,Sys.Date(),"day"),25,replace = TRUE)
)

respeciate_generic(x=df,
                   group_vars=c('ptid','type'),
                   species_col='spec',
                   date_col='specdate',
                   window = 14)[]

}
