% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.epimodel}
\alias{summary.epimodel}
\alias{print.summary.epimodel}
\title{Summary method for epimodel objects}
\usage{
\method{summary}{epimodel}(
  object,
  pars = NULL,
  regex_pars = NULL,
  probs = c(0.1, 0.5, 0.9),
  ...,
  digits = 1
)

\method{print}{summary.epimodel}(x, digits = max(1, attr(x, "print.digits")), ...)
}
\arguments{
\item{object}{A fitted model object returned by \code{\link{epim}}.
See \code{\link{epimodel-objects}}.}

\item{pars}{A character vector giving a subset of parameters to include.
Default is NULL, in which case all parameters are included.}

\item{regex_pars}{A character vector of regular expressions to select parameters.
If pars is also used, regex_pars is used in conjunction with pars.}

\item{probs}{A numeric vector of probabilities for computing quantiles of
parameter estimates.}

\item{...}{Not used.}

\item{digits}{Number of digits to use for formatting numbers when printing.}

\item{x}{An object of class \code{"summary.epimodel"}.}
}
\value{
An object of class \code{"summary.epimodel"}.
}
\description{
Provides a summary of parameter estimates and MCMC diagnostics. Similar
to \code{\link[rstanarm]{summary.stanreg}} in \pkg{rstanarm}.
}
