% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pub_nidss_flu}
\alias{pub_nidss_flu}
\title{NIDSS flu doctor visits (Taiwan)}
\usage{
pub_nidss_flu(
  regions,
  epiweeks = "*",
  ...,
  issues = NULL,
  lag = NULL,
  fetch_args = fetch_args_list()
)
}
\arguments{
\item{regions}{character. Regions to fetch.}

\item{epiweeks}{\code{\link{timeset}}. Epiweeks to fetch. Defaults to all ("*") dates.}

\item{...}{not used for values, forces later arguments to bind by name}

\item{issues}{\code{\link{timeset}}. Optionally, the issues to fetch. If not set, the
most recent issue is returned. Mutually exclusive with \code{lag}.}

\item{lag}{integer. Optionally, the lag of the issues to fetch. If not set,
the most recent issue is returned. Mutually exclusive with \code{issues}.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/nidss_flu.html}

Obtains information on outpatient inluenza-like-illness from Taiwan National
Infectious Disease Statistical System.
}
\examples{
\dontrun{
pub_nidss_flu(regions = "taipei", epiweeks = epirange(201501, 201601))
}
}
\keyword{endpoint}
