% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_epicontacts.R
\name{vis_epicontacts}
\alias{vis_epicontacts}
\title{Plot epicontacts objects using visNetwork}
\usage{
vis_epicontacts(x, group = "id", annot = TRUE, legend = TRUE,
  legend_max = 10, col_pal = cases_pal, NA_col = "lightgrey",
  width = "90\%", height = "700px", selector = TRUE, editor = FALSE,
  edge_width = 3, ...)
}
\arguments{
\item{x}{An \code{\link{epicontacts}} object.}

\item{group}{An index or character string indicating which field of the
linelist should be used to color the nodes.}

\item{annot}{An index, logical, or character string indicating which fields
of the linelist should be used for annotating the nodes. Logical will be
recycled if necessary, so that the default \code{TRUE} effectively uses all
columns of the linelist.}

\item{legend}{A logical indicating whether a legend should be added to the
plot.}

\item{legend_max}{The maximum number of groups for a legend to be displayed.}

\item{col_pal}{A color palette for the groups.}

\item{NA_col}{The color used for unknown group.}

\item{width}{The width of the output, in html compatible format (e.g. '90\%'
or '800px').}

\item{height}{The height of the output, in html compatible format
(e.g. '800px').}

\item{selector}{A logical indicating if the selector tool should be used;
defaults to TRUE.}

\item{editor}{A logical indicating if the editor tool should be used;
defaults to FALSE.}

\item{edge_width}{An integer indicating the width of the edges. Defaults to
3.}

\item{...}{Further arguments to be passed to \code{visNetwork}.}
}
\value{
The same output as \code{visNetwork}.
}
\description{
This function plots \code{\link{epicontacts}} objects using the
\code{visNetwork} package. The produced object is an \code{htmlwidget} which
will need rendering within a web browser.
}
\examples{
if (require(outbreaks)) {

## example using MERS outbreak in Korea, 2014
head(mers_korea_2015[[1]])
head(mers_korea_2015[[2]])

x <- make_epicontacts(linelist=mers_korea_2015[[1]],
                       contacts = mers_korea_2015[[2]],
                       directed=TRUE)

\dontrun{
plot(x)
plot(x, group = "place_infect")
plot(x, group = "loc_hosp", legend_max=20, annot=TRUE)
}
}
}
\seealso{
\code{\link[visNetwork]{visNetwork}} in the package \code{visNetwork}.
}
\author{
Thibaut Jombart (\email{thibautjombart@gmail.com})
VP Nagraj (\email{vpnagraj@virginia.edu})
}
