% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_clusters_by_size.R
\name{subset_clusters_by_size}
\alias{subset_clusters_by_size}
\title{Subset clusters from epicontacts object by cluster size}
\usage{
subset_clusters_by_size(x, cs = NULL, cs_min = NULL, cs_max = NULL)
}
\arguments{
\item{x}{an \code{\link{epicontacts}} object}

\item{cs}{cluster size to be used for subsetting}

\item{cs_min}{minimum cluster size for subsetting}

\item{cs_max}{maximum cluster size for subsetting}
}
\value{
An \code{\link{epicontacts}} object whose contact dataframe corresponds to
all clusters of specified cluster sizes.
}
\description{
This function subsets an \code{\link{epicontacts}} object based on defined
size(s) of clusters (clusters being groups of connected
individuals/nodes). Subsetting may be done by specifying a particular cluster
size of interest, minimum cluster size, maximum cluster size, or a range
(minimum and maximum) of cluster sizes.
}
\examples{
if (require(outbreaks)) {
## build data
x <- make_epicontacts(ebola_sim$linelist, ebola_sim$contacts,
                       id="case.id", to="case.id", from="infector",
                       directed=TRUE)


## subset based on cluster size range
x_subset <- subset_clusters_by_size(x, cs_min = 12, cs_max = 15)


## subset based on single cluster size
x_subset <- subset_clusters_by_size(x, cs = 12)


## subset based on minimum cluster size
x_subset <- subset_clusters_by_size(x, cs_min = 10)


## subset based on maximum cluster size
x_subset <- subset_clusters_by_size(x, cs_max = 9)
}
}
\author{
Nistara Randhawa (\email{nrandhawa@ucdavis.edu})
}
