% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_scc.R
\name{sc_contain_steps}
\alias{sc_contain_steps}
\title{Do steps appear in sufficient causes?}
\usage{
sc_contain_steps(scc, steps = NULL, output = c("nice", "table"))
}
\arguments{
\item{scc}{An object of class \code{epicmodel_scc}.}

\item{steps}{A character vector containing step IDs. IF NULL (default), provides a list of all steps.}

\item{output}{A single element of type character, either "nice" (default) or "table". If "table", returns a list (or data.frame if steps = NULL).
If "nice", a nicely formated output is printed in the console.}
}
\value{
Either a list (\code{output} = "table") with length equal to the number of sufficient causes and each element being a named vector of
TRUE/FALSE with the variables in \code{steps} as names and TRUE indicating that the step appears in the corresponding sufficient cause, or a nicely
formated output in the console (\code{output} = "nice"). If steps = NULL and output = "table", returns a data.frame, which contains variables
\code{id_step} and \code{desc_step} from the \code{epicmodel_steplist_checked} data.frame \code{step}.
}
\description{
Extracts from a SCC model, if certain steps are part of the mechanism of sufficient causes. If you want a list of all steps, ignore argument
\code{steps}.
}
\examples{
# Create some SCC model
steplist_checked <- check_steplist(steplist_rain)
scc_model <- create_scc(steplist_checked)

# Check if one or more steps are part of the mechanism for each sufficient cause
sc_contain_steps(scc_model, c("THENa1","THENa5"))
}
