% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{epiGWAS}
\alias{epiGWAS}
\title{Runs a selection of epistasis detection methods in a joint manner}
\usage{
epiGWAS(A, X, Y, propensity, methods = "all", parallel = TRUE,
  shift = 0.1, ...)
}
\arguments{
\item{A}{target variant}

\item{X}{rest of the genotype}

\item{Y}{phenotype}

\item{propensity}{propensity scores}

\item{methods}{character vector for the epistasis detection methods to call}

\item{parallel}{whether to perform support estimation in a
parallelized fashion for the modified outcome family of methods}

\item{shift}{regularization parameter for \code{\link{shifted_outcome}}}

\item{...}{additional arguments to be passed to \code{stabilityGLM} or
\code{stabilityBIG}}
}
\value{
list of numeric vectors. Each vector corresponds to the auc scores
    of a particular method in \code{methods}.
}
\description{
This function is a wrapper for the different epistasis detection
methods implemented in this package. If \code{methods} is \code{"all"}, we run
\code{OWL} and the four modified outcome approaches. Otherwise, we run a
selection of those methods. In this case, the \code{methods} argument is a
character vector with its entries being the names of the functions to call.
}
\examples{
n <- 20
p <- 8
X <- matrix((runif(n * p) < 0.4) + (runif(n * p) < 0.4),
             ncol = p, nrow = n) # SNP matrix
A <- rbinom(n, 1, 0.3)
propensity <- runif(n, min = 0.4, max = 0.8)
Y <- rnorm(n)
aucs <- epiGWAS(A, X, Y, propensity, lambda_min_ratio = 0.01, parallel = FALSE,
                 shift = 0.2, n_subsample = 1, short = TRUE, eps = 1e-4,
                 methods = c("normalized_outcome", "robust_outcome"))

names(aucs)

}
\seealso{
\code{OWL}, \code{modified_outcome}, \code{shifted_outcome},
    \code{normalized_outcome} and \code{robust_outcome}
}
