% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{import}
\alias{import}
\title{Import Data from Various File Formats}
\usage{
import(file_path, ...)
}
\arguments{
\item{file_path}{Character string specifying the path to the input file or
a URL pointing to the dataset.}

\item{...}{Additional arguments to be passed to the underlying read
functions. These arguments are specific to the file format being imported.
Please refer to the documentation of each package used for more
information.}
}
\value{
A data frame or appropriate R object containing the imported data.
}
\description{
This function provides a unified interface for importing data from various
file formats supported by the \code{\link[=rio]{rio}} package. The format is
automatically detected from the file extension to simplify the importing process.
}
\examples{
# Locate test data directory
path <-  system.file("extdata",
                     package = "epiCleanr")

# Import a CSV file
data_csv <- import(file_path = file.path(path, "test_data.csv"))

# Import an Excel file
data_excel <- import(file_path = file.path(path, "test_data.xlsx"))

# Import a Stata DTA file
data_dta <- import(file_path = file.path(path, "test_data.dta"))

# Import an RDS file
data_rds <- import(file_path = file.path(path, "test_data.rds"))

# Import an RData file
data_rdata <- import(file_path = file.path(path, "test_data.RData"))

# Import an SPSS file
data_spss <- import(file_path = file.path(path, "test_data.sav"))

}
\seealso{
\code{\link[=rio]{rio::import()}},  which this function is based on.
}
