% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rtoolkit.R
\name{ENgetflowunits}
\alias{ENgetflowunits}
\title{Retrieve a code number indicating the units used to express all flow rates.}
\usage{
ENgetflowunits()
}
\value{
An integer, the code numnber indicating the flow units.
}
\description{
\code{ENgetflowunits} retrieves a code number indicating the units used to express all flow rates.
}
\note{
Flow units codes are as follows:
  \tabular{lll}{
		0	\tab = \code{EN_CFS} \tab	cubic feet per second\cr
		1	\tab = \code{EN_GPM} \tab	gallons per minute\cr
		2	\tab = \code{EN_MGD} \tab	million gallons per day\cr
		3 	\tab = \code{EN_IMGD} \tab	Imperial mgd\cr
		4	\tab = \code{EN_AFD} \tab	acre-feet per day\cr
		5	\tab = \code{EN_LPS} \tab	liters per second\cr
		6	\tab = \code{EN_LPM} \tab	liters per minute\cr
		7	\tab = \code{EN_MLD} \tab	million liters per day\cr
		8	\tab = \code{EN_CMH} \tab	cubic meters per hour\cr
		9	\tab = \code{EN_CMD} \tab	cubic meters per day
  }

  Flow units are specified in the \code{[OPTIONS]} section of the EPANET Input file.

  Flow units in liters or cubic meters implies that metric units are used for all other quantities in 
  addition to flow. Otherwise US units are employed. (See Units of Measurement).
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENgetflowunits()
ENclose()
}
\seealso{
\url{http://wateranalytics.org/EPANET/group___toolkit_options.html}
}
