% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envvar_get_list.R
\name{envvar_get_list}
\alias{envvar_get_list}
\alias{envvar_get_csv}
\alias{envvar_get_psv}
\title{Environment variables containing lists}
\usage{
envvar_get_list(x, pattern = ":", default = NULL, validate = NULL, ...)

envvar_get_csv(x, default = NA, validate = NULL)

envvar_get_psv(x, default = NA, validate = NULL)
}
\arguments{
\item{x}{String containing an environment variable name}

\item{pattern}{String specifying the pattern used to separate elements in the
list.}

\item{default}{Optional default value if the environment variable is not set}

\item{validate}{Optional function that checks a value for validity}

\item{...}{Additional arguments passed to \link{strsplit}}
}
\value{
A list
}
\description{
\code{envvar_get_list() } gets lists from environment variables. At
the moment, only unnamed lists are supported.

\code{envvar_get_csv()} and \code{envvar_get_psv()} are an easy way to
use \code{envvar_get_list()} with comma or pipe separators.
}
\examples{
# Get the value of `$PATH`, creating a list with elements for each directory
envvar_get_list("PATH")

# Parse an list separated by `|`
envvar_set("ROOMMATES" = "nandor|laszlo|nadja|guillermo|colin")
envvar_get_psv("ROOMMATES")
}
