% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pacificCentric.R
\name{pacificCentric}
\alias{pacificCentric}
\title{Center raster on the Pacific}
\usage{
pacificCentric(r, crop = TRUE)
}
\arguments{
\item{r}{rasterLayer or SpatRaster in unprojected geographic coordinates}

\item{crop}{logical, should raster then be cropped to longitude [100, 300]}
}
\value{
rasterLayer or SpatRaster
}
\description{
Takes a raster that is centered on 0 longitude (default) and recenters it on the Pacific
}
\details{
Cropping to [100, 300] is equivalent to [100, -60]
}
\examples{
# Find example rasters
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)
tmin1 <- rast(grep('tmin_1\\\\.', rasterFiles, value=TRUE))

pacificCentric(tmin1, crop = TRUE)
}
\author{
Pascal Title
}
