% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalx.r
\name{globalx}
\alias{globalx}
\title{"Friendly" wrapper for terra::global() for calculating raster statistics}
\usage{
globalx(x, fun, na.rm = TRUE, ..., weights = NULL)
}
\arguments{
\item{x}{A \code{SpatRaster}.}

\item{fun}{A function or the name of a function (in quotes). See \code{\link[terra]{global}} for more details.}

\item{na.rm}{If \code{TRUE} (default), then the function in \code{fun} will ignore \code{NA} cells.}

\item{...}{Additional arguments to pass to \code{fun}.}

\item{weights}{Either \code{NULL} or a \code{SpatRaster}.}
}
\value{
A numeric vector, one value per layer in \code{x}.
}
\description{
Calculate "global" statistics across all the values in a raster. This function is a wrapper for \code{\link[terra]{global}}.  That function, by default, sets \code{na.rm = FALSE}, so any cell that is \code{NA} can cause the summary statistic to also be \code{NA} (usually undesirable). The function also returns a \code{data.frame}, so often needs a further line of code to get the actual value(s). This function sets \code{na.rm = TRUE} by default, and returns a numeric vector (not a \code{data.frame}).
}
\examples{

library(terra)

r <- rast(ncols=10, nrows=10)
values(r) <- 1:ncell(r)


global(r, 'sum') # terra
globalx(r, 'sum') # enmSdmX

global(r, "mean", na.rm=TRUE)[1, 1] # terra... same as enmSdmX::globalx

}
