% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getValueByCell.r
\name{getValueByCell}
\alias{getValueByCell}
\alias{setValueByCell}
\title{Get or assign values to cells in a raster}
\usage{
getValueByCell(x, cell, format = "raster")

setValueByCell(x, val, cell, format = "raster")
}
\arguments{
\item{x}{A \code{SpatRaster}.}

\item{cell}{Cell indices. There must be one per value in \code{val}.}

\item{format}{The type of cell indexing used. This can be either "raster" for row indexing (default) or "matrix" for column indexing. Row indexing (the default for rasters), starts with cell "1" in the upper left, cell "2" is to its right, and so on. Numbering then wraps around to the next row. Column indexing (the default for matrices) has the cell "1" in the upper left corner of the matrix. The cell "2" is below it, and so on. The numbering then wraps around to the top of the next column.}

\item{val}{One or more values. If more the number of cells specified is greater than the number of values in \code{val}, then values in \code{val} will be recycled.}
}
\value{
A data frame (\code{getValueByCell}) with cell numbers (in row format), or a \code{SpatRaster} (\code{setValueByCell}).
}
\description{
These functions get values from a raster at specific cells, or values to specific cells.
}
\examples{

library(terra)
x <- rast(nrow=10, ncol=10)
x[] <- round(10 * runif(100))

cell <- c(1, 20, 40, 80)
getValueByCell(x, cell = cell)
getValueByCell(x, cell = cell, format = 'matrix')

y <- setValueByCell(x, val = 20, cell = cell)
plot(y)
z <- setValueByCell(x, val = 30, cell = cell, format = 'matrix')

plot(c(x, y, z))

}
\seealso{
\code{\link[terra]{setValues}}, \code{\link[terra]{values}}
}
