% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-plotting.R
\name{create_spectrogram_image_as_raster}
\alias{create_spectrogram_image_as_raster}
\title{Create spectrogram image as raster}
\usage{
create_spectrogram_image_as_raster(
  audioFilePath,
  begin = 0,
  end = 0,
  windowSizeInSecs = 0.01,
  alpha = 0.16,
  lowerFreq = 0,
  upperFreq = 5000,
  window = "GAUSS",
  dynRangeInDB = 70,
  audioChannel = 1,
  preEmphasisFilterFactor = 0.97,
  invert = F
)
}
\arguments{
\item{audioFilePath}{path to audio file to plot spectrogram of}

\item{begin}{begin time in seconds (passed into begin parameter of \code{wrassp::read.AsspDataObj})}

\item{end}{end time in seconds (passed into end parameter of \code{wrassp::read.AsspDataObj})}

\item{windowSizeInSecs}{window size in seconds}

\item{alpha}{value of spectrogram}

\item{lowerFreq}{lower frequency limit of spectrogram}

\item{upperFreq}{upper frequency limit of spectrogram}

\item{window}{window type used in spectrogram calculation. Allowed values
are:
\itemize{
 \item "BARTLETT"
 \item "BARTLETTHANN"
 \item "BLACKMAN"
 \item "COSINE"
 \item "GAUSS" (the default)
 \item "HAMMING"
 \item "HANN"
 \item "LANCZOS"
 \item "RECTANGULAR"
 \item "TRIANGULAR"
}}

\item{dynRangeInDB}{dynamic range in DB of spectrogram}

\item{audioChannel}{channel of audio file to draw spectrogram of (only
applicable when using multi-chnanel audio files)}

\item{preEmphasisFilterFactor}{used in time domain for amplifying high-freqs}

\item{invert}{invert the colors of the spectrogram}
}
\value{
a image raster object
}
\description{
Create spectrogram image as raster
}
