% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-bas_webservices.R
\name{runBASwebservice_minni}
\alias{runBASwebservice_minni}
\title{Creates a rough phonetic segmentation by running the phoneme decoder webservice MINNI.}
\usage{
runBASwebservice_minni(handle, language,
  minniAttributeDefinitionName = "MINNI", rootLevel = NULL,
  params = list(), perspective = "default", resume = FALSE,
  verbose = TRUE)
}
\arguments{
\item{handle}{emuDB handle}

\item{language}{language(s) to be used. If you pass a single string (e.g. "deu-DE"), this language will be used for all bundles.
Alternatively, you can select the language for every bundle individually. To do so, you must pass a data frame with the columns
session, bundle, language. This data frame must contain one row for every bundle in your emuDB.
Up-to-date lists of the languages accepted by all webservices can be found here:
\url{https://clarin.phonetik.uni-muenchen.de/BASWebServices/services/help}}

\item{minniAttributeDefinitionName}{attribute name for the MINNI segmentation}

\item{rootLevel}{if provided, the new level will be linked to the root level}

\item{params}{named list of parameters to be passed on to the webservice. It is your own reponsibility to
ensure that these parameters are compatible with the webservice API
(see \url{https://clarin.phonetik.uni-muenchen.de/BASWebServices/services/help}).
Some options accepted by the API (e.g. output format) cannot be set when calling a webservice from within emuR,
and will be overridden.}

\item{perspective}{the webApp perspective that the new level will be added to.
If NULL, the new level is not added to any perspectives.}

\item{resume}{If a previous call to this function has failed (and you think you have fixed the issue
that caused the error), you can set resume=TRUE to recover any progress made up to that point. This
will only work if your R temporary directory has not been deleted or emptied in the meantime.}

\item{verbose}{Display progress bars and other information}
}
\description{
The MINNI phoneme decoder performs phoneme-based decoding on the signal without input from
the transcription. Therefore, labelling quality is usually worse than that obtained from
MAUS (\link{runBASwebservice_maus}). Contrary to MAUS however, there is no need for a
pre-existing transcription.
}
\details{
All necessary level, link and attribute definitions are created in the process.
}
\seealso{
Other BAS webservice functions: \code{\link{runBASwebservice_all}},
  \code{\link{runBASwebservice_chunker}},
  \code{\link{runBASwebservice_g2pForPronunciation}},
  \code{\link{runBASwebservice_g2pForTokenization}},
  \code{\link{runBASwebservice_maus}},
  \code{\link{runBASwebservice_pho2sylCanonical}},
  \code{\link{runBASwebservice_pho2sylSegmental}}
}
