% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.DBconfig.EMUwebAppConfig.R
\name{AddListRemovePerspective}
\alias{AddListRemovePerspective}
\alias{add_perspective}
\alias{list_perspectives}
\alias{remove_perspective}
\title{Add / List / Remove perspective to / of / from emuDB}
\usage{
add_perspective(emuDBhandle, name)

list_perspectives(emuDBhandle)

remove_perspective(emuDBhandle, name)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{name}{name of perspective}
}
\description{
Add / List / Remove perspective to / of / from emuDB. The EMU-webApp subdivides different ways 
to look at an emuDB into so called perspectives. These perspectives, 
between which you can switch in the web application, contain 
information on what levels are displayed, which ssffTracks are drawn, 
and so on. For more information on the structural elements of an emuDB 
see \code{vignette{emuDB}}.
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB 
# (see ?load_emuDB for more information)

# add perspective called "justTones" to the ae emuDB
add_perspective(emuDBhandle = ae,
                name = "justTones") 
                
# add levelCanvasOrder so only the "Tone" level is displayed
set_levelCanvasesOrder(emuDBhandle = ae, 
                       perspectiveName = "justTones", 
                       order = c("Tone"))

# list perspectives of ae emuDB
list_perspectives(emuDBhandle = ae)

# remove newly added perspective
remove_perspective(emuDBhandle = ae,
                   name = "justTones")
                   
}

}
\keyword{DBconfig}
\keyword{Emu}
\keyword{database}
\keyword{emuDB}

