% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-objDocs.R
\name{start.emusegs}
\alias{end.emusegs}
\alias{end.trackdata}
\alias{start.emusegs}
\alias{start.trackdata}
\title{Start and end times for EMU segment lists and trackdata objects}
\arguments{
\item{x}{a segment list or a trackdata object}

\item{...}{due to the generic only}
}
\value{
A vector of times.
}
\description{
Obtain start and end times for EMU segment lists and trackdata objects
}
\details{
The function returns the start and/or end times of either a segment list or
a trackdata object. The former refers to the boundary times of segments,
the latter the start and end times at which the tracks from segments occur.
start.emusegs and end.emusegs give exactly the same output as start and end
respectively.
}
\examples{

# start time of a segment list
start(polhom)
# duration of a segment list
end(polhom) - start(polhom)
# duration from start time of segment list
# and start time of parallel EPG trackdata
start(polhom) - start(polhom.epg)


}
\author{
Jonathan Harrington
}
\seealso{
\code{\link{tracktimes}}
}
\keyword{utilities}

