% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableStack.R
\name{tableStack}
\alias{tableStack}
\title{Tabulation of variables in a stack form}
\usage{
tableStack(vars, dataFrame, minlevel = "auto", maxlevel = "auto",
  count = TRUE, na.rm = FALSE, means = TRUE, medians = FALSE,
  sds = TRUE, decimal = 2, total = TRUE, var.labels = TRUE,
  var.labels.trunc = 150, reverse = FALSE, vars.to.reverse = NULL,
  by = NULL, vars.to.factor = NULL, iqr = "auto",
  prevalence = FALSE, percent = c("column", "row", "none"),
  frequency = TRUE, test = TRUE, name.test = TRUE,
  total.column = FALSE, simulate.p.value = FALSE, sample.size = TRUE,
  assumption.p.value = 0.01, NAcol = FALSE, NArow = FALSE,
  drplvls = FALSE)
}
\arguments{
\item{vars}{a vector of variables in the data frame. The imput may be given with or without quotes.}

\item{dataFrame}{source data frame of the variables}

\item{minlevel}{possible minimum value of items specified by user}

\item{maxlevel}{possible maximum value of items specified by user}

\item{count}{whether number of valid records for each item will be displayed}

\item{na.rm}{whether missing value would be removed during calculation mean score of each person}

\item{means}{whether means of all selected items will be displayed}

\item{medians}{whether medians of all selected items will be displayed}

\item{sds}{whether standard deviations of all selected items will be displayed}

\item{decimal}{number of decimals displayed}

\item{total}{display of means and standard deviations of total and average scores}

\item{var.labels}{presence of descriptions of variables on the last column of output}

\item{var.labels.trunc}{number of characters used for variable description}

\item{reverse}{whether item(s) negatively correlated with other majority will be reversed}

\item{vars.to.reverse}{variable(s) to reverse}

\item{by}{a variable for column breakdown. If NONE is given, only the 'total column' will be displayed. More on Details.}

\item{vars.to.factor}{variable(s) to be converted to factor for tabulaton}

\item{iqr}{variable(s) to display median and inter-quartile range}

\item{prevalence}{for logical or dichotomous variables, whether prevalence of the dichotomous row variable in each column subgroup will be displayed}

\item{percent}{type of percentage displayed when the variable is categorical and for NArow when activated. Default is column}

\item{frequency}{whether to display frequency in the cells when the variable is categorical and for NArow when activated}

\item{test}{whether statistical test(s) will be computed}

\item{name.test}{display name of the test and relevant degrees of freedom}

\item{total.column}{whether to add 'total column' to the output or not}

\item{simulate.p.value}{simulate P value for Fisher's exact test}

\item{sample.size}{whether to display non-missing sample size of each column}

\item{assumption.p.value}{level of Bartlett's test P value to judge whether the comparison and the test should be parametric}

\item{NAcol}{whether to add 'NA column' to the output or not}

\item{NArow}{whether to add 'NA rows' for each variable to the output or not}

\item{drplvls}{whether to hide non used levels on factor and character variables or not}
}
\value{
an object of class 'tableStack' and 'list' when by=NULL
\tabular{ll}{
\code{results} \tab an object of class 'noquote' which is used for print out\cr
\code{items.reversed}  \tab name(s) of variable(s) reversed\cr
\code{total.score} \tab a vector from 'rowSums' of the columns of variables specified in 'vars'\cr
\code{mean.score}  \tab a vector from 'rowMeans' of the columns of variables specified in 'vars'\cr
\code{mean.of.total.scores}  \tab mean of total scores\cr
\code{sd.of.total.scores}  \tab standard deviation of total scores\cr
\code{mean.of.average.scores}  \tab mean of mean scores\cr
\code{sd.of.average.scores}  \tab standard deviation of mean scores
}
When 'by' is specified, an object of class 'tableStack' and 'table is returned.
}
\description{
There are two functionalities: Tabulation of variables with the same possible range of distribution and stack into a new table with or without other descriptive statistics or to breakdown distribution of more than one row variables against a column variable
}
\details{
This function is a clone of \code{tableStack} from the \code{epiDisplay} package. Comparing to the original, tt adds options to show the NA in the variables as categories, similar to the option \code{useNA} in the \code{table} function, and it also fix few bugs, such as showing the \code{total.column} without the need to \code{test = TRUE}, and to show or hide levels with zero counts without returning error.

This function simultaneously explores several variables with a fixed integer rating scale. For non-factor variables, the default values for tabulation are the minimum and the maximum of all variables but can be specified by the user.

When 'by' is omitted, all variables must be of the same class, and must be 'integer', 'factor' or 'logical. Some parameters are only used if by is omitted, others are only used if by is available. The by-omitted dependent variable are minlevel, maxlevel, count, na.rm, means, medians, sds, total, reverse, vars.to.reverse. The by-available dependent variables are iqr, prevalence, percent, frequency, test, name.test, total.column, simulate.p.value, sample.size, assumption.p.value, NArow, NAcol, drplvls.
Unlike function 'alpha', the argument 'reverse' has a default value of FALSE. This argument is ignored if 'vars.to.reverse' is specified.

Options for 'reverse', 'vars.to.reverse' and statistics of 'means', 'medians', 'sds' and 'total' are available only if the items are not factor. To obtain statistics of factor items, users need to use 'unclassDataframe' to convert them into integer.

When the 'by' argument is given, 'reverse' and 'vars.to.reverse' do not apply, as mentioned before. Instead, columns of the 'by' variable will be formed. A table will be created against each selected variable. If the variable is a factor or coerced to factor with 'vars.to.factor', cross-tabulation will result with percents as specified, ie. "column", "row", or "none" (FALSE). For a dichotomous row variable, if set to 'TRUE', the prevalence of row variable in the form of a fraction is displayed in each subgroup column. For objects of class 'numeric' or 'integer', means with standard deviations will be displayed. For variables with residuals that are not normally distributed or where the variance of subgroups are significantly not normally distributed (using a significance level of 0.01), medians and inter-quartile ranges will be presented if the argument 'iqr' is set to "auto" (by default). Users may specify a subset of the selected variables (from the 'vars' argument) to be presented in such a form. Otherwise, the argument could be set as any other character string, except the variables names, to insist to present means and standard deviations.

When 'test = TRUE' (default), Pearson's chi-squared test (or a two-sided Fisher's exact test, if the sample size is small) will be carried out for a categorical variable or a factor. Parametric or non-parametric comparison and test will be carried out for a object of class 'numeric' or 'integer' (See 'iqr' and 'assumption.p.value' below). If the sample size of the numeric variable is too small in any group, the test is omitted and the problem reported.

For Fisher's exact test, the default method employs 'simulate.p.value = FALSE'. See further explanation in 'fisher.test' procedure. If the dataset is extraordinarily large, the option may be manually set to TRUE.

When 'by' is specified as a single character object (such as 'by="none"') or when 'by = NONE' there will be no column breakdown and all tests will be omitted. Only the total column is displayed. Only the 'total' column is shown.

If this 'total column' is to accompany the 'by' breakdown, the argument 'total.column=TRUE' should be specified. The 'sample.size' is TRUE by default. The total number of records for each group is displayed in the first row of the output. However, the variable in each row may have some missing records, the information on which is reported by NArow for each variable on 'vars' and by NAcol for the variable on 'by'.

By default, Epicalc sets 'var.labels=TRUE' in order to give nice output. However, 'var.labels=FALSE' can sometimes be more useful during data exploration. Variable numbers as well as variable names are displayed instead of variable labels. Names and numbers of abnormally distributed variables, especially factors with too many levels, can be easily identified for further relevelling or recoding.

The argument 'iqr' has a default value being "auto". Non-parametric comparison and test will be automatically chosen if Bartlett's test P value is below the 'assumption.p.value'.

The test can be forced to parametric by setting 'iqr=NULL' and to non-parametric by if iqr is set to the variable number of cont.var (See examples.).
}
\examples{
set.seed(1)
data <- data.frame(sex = sample(c("M","F"), 50, rep = TRUE),
age = sample(c(NA,20:70), 50, rep = TRUE),
admissionType = sample(c(NA,"urgency", "clinical", "scheduled"), 50, rep = TRUE),
hospitalizationTime = sample(c(0:10), 50, rep = TRUE),
numberOfChildren = sample(c(NA,0:3), 50, rep = TRUE),
cancerInFamily = sample(c(NA,TRUE,FALSE), 50, rep = TRUE),
diabetesInFamily = sample(c(TRUE,FALSE), 50, rep = TRUE),
thrombosisInFamily = sample(c(TRUE,FALSE), 50, rep = TRUE),
mentaldiseasesInFamily = sample(c(TRUE,FALSE), 50, rep = TRUE),
cardiadicdiseaseInFamily = sample(c(NA,TRUE,FALSE), 50, rep = TRUE),
readmission = sample(c(NA,TRUE,FALSE), 50, rep = TRUE))

attach(data)
tableStack(cancerInFamily:cardiadicdiseaseInFamily, dataFrame = data)
detach(data)
tableStack(cancerInFamily:cardiadicdiseaseInFamily, data) # Default data frame is data
# "by" compares variables
tableStack(cancerInFamily:cardiadicdiseaseInFamily, data, by= readmission)
# "prevalence" returns the prevalence instead of the absolute values
tableStack(cancerInFamily:cardiadicdiseaseInFamily, data,
by= readmission, prevalence=TRUE)
# "percent" as FALSE hides the percentage in parenthesis
tableStack(cancerInFamily:cardiadicdiseaseInFamily, data,
by= readmission, percent=FALSE)
# "name.test" as FALSE hides the column that shows the tests names
tableStack(cancerInFamily:cardiadicdiseaseInFamily, data,
by= readmission, percent=FALSE, name.test=FALSE)
# "NAcol" displays a column of NA values on the variable on "by"
tableStack(cancerInFamily:cardiadicdiseaseInFamily, data,
by= readmission, NAcol = TRUE)
# "NArow" displays rows of NA values on the variables on "vars"
tableStack(cancerInFamily:cardiadicdiseaseInFamily, data,
by= readmission, NAcol = TRUE, NArow = TRUE)

# the specification of the vars may be done as the range
tableStack(vars=2:7, data, by=sex)
# "by" var may be specified as "none" and the selected vars will be crossed only against the total
tableStack(vars=2:7, data, by="none")
# by = NONE works just as by = "none"
tableStack(vars=2:7, data, by = NONE)
# total.column displays a column of totals in adition to the variable on by
tableStack(vars=2:7, data, by=sex, total.column=TRUE)

var.labels <- c("sex", "Type of admission for each patient",
"age", "Duration time in days of the patient's hospitalization",
"Number of children that the patient have",
"whether or not the patient has cancer in family",
"whether or not the patient has diabetes in family",
"whether or not the patient has thrombosis in family",
"whether or not the patient has mental diseases in family",
"whether or not the patient has cardiac diseases in family",
"whether or not the patient is on a relapse admission")
#setting the attribute var.labels
attr(data, "var.labels") <- var.labels
rm(var.labels)

# May need full screen of Rconsole
tableStack(vars=c(numberOfChildren,hospitalizationTime), data)
# Fits in with default R console screen
tableStack(vars=c(numberOfChildren,hospitalizationTime), data,
var.labels.trunc=35)
tableStack(vars=c(age,numberOfChildren,hospitalizationTime),
data, reverse=TRUE) -> a
a
## Components of 'a' have appropriate items reversed
a$mean.score -> mean.score
a$total.score -> total.score
data$mean.score <- mean.score
data$total.score <- total.score

# hiding the test column
tableStack(c(age, numberOfChildren,hospitalizationTime,
mean.score,total.score), data, by=sex, test=FALSE)
# variables specified on iqr will not display SD but IQR instead
tableStack(3:5, data, by=sex, iqr=hospitalizationTime)
## 'vars' can be mixture of variables of different classes
tableStack(3:5, data, by=admissionType,
iqr=c(hospitalizationTime, total.score))

data$highscore <- mean.score > 4
# a variable with some comparison may be created easily
tableStack(mean.score:highscore, data,
by=sex, iqr=total.score)

# the percentage information may be hidden
tableStack(vars=c(readmission,admissionType),
data, by=sex, percent="none")
# it may be shown the prevalende of the
# variable instead of the values themselves
tableStack(vars=c(readmission,admissionType), data,
by=sex, prevalence = TRUE)
# the name of the tests may be hidden
# while the test itself still shows
tableStack(vars=c(readmission,admissionType), data,
by=sex, name.test = FALSE)

## Variable in numeric or factor
# as continuous varaibles
tableStack(vars=3:5, data, by=sex)
# as factors
tableStack(vars=3:5, data, by=sex, vars.to.factor = 3:5)

## Using drplvls
# a dataframe will be created containing a factor with an unused level
bloodbank <- data.frame(AgeInDays =
    sample(0:15,200, replace = TRUE), Type =
    factor(sample(c("A","B","0"), 200, replace = TRUE),
      levels = c("A","B","AB","0")), Origin =
    sample(c("US","CA"), 200, replace = TRUE))

# by using drplvls the row of the unused fator is hidden
tableStack(vars = c(AgeInDays, Type),
bloodbank, by = Origin) #usual
tableStack(vars = c(AgeInDays, Type),
bloodbank, by = Origin,
drplvls = TRUE) # with drplvls

rm(total.score, mean.score, a, data, bloodbank)
}
\references{
'table', 'tab1', 'summ', 'alpha', 'unclassDataframe'
}
\author{
Virasakdi Chongsuvivatwong <cvirasak@medicine.psu.ac.th>
Caio Ferreira <caio.ferreira@epimedsolutions.com>
Lunna Borges <caio.ferreira@epimedsolutions.com>
Pedro Brasil <pedro.brasil@epimedsolutions.com>
}
