% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reclass.R
\name{reclass}
\alias{reclass}
\alias{print.reclass}
\alias{plot.reclass}
\title{Comparisson of the Standardized Resource Use (SRU)}
\usage{
reclass(x, y, same = TRUE, plot = FALSE, digits = 2, compare = c("SRU",
  "SMR", "BOTH"), decreasing = FALSE, complete.rank = TRUE)

\method{print}{reclass}(x, ...)

\method{plot}{reclass}(x, ..., xlim_x = range(x$smr_x),
  ylim_x = range(x$sru_x), xlim_y = range(x$smr_y),
  ylim_y = range(x$sru_y), xlab = "SMR", ylab = "SRU",
  points.arg_x = list(pch = 21, col = "white", bg = "yellow", cex = 2),
  points.arg_y = list(pch = 21, col = "white", bg = "yellow", cex = 2),
  med.arg_x = list(col = "dodgerblue4", lwd = 2, lty = 1),
  med.arg_y = list(col = "dodgerblue4", lwd = 2, lty = 1),
  tert.arg_x = list(col = "darkorange2", lty = 2, lwd = 1),
  tert.arg_y = list(col = "darkorange2", lty = 2, lwd = 1),
  text.arg_x = list(labels = seq(1, nrow(x$tab)), cex = 0.6),
  text.arg_y = list(labels = seq(1, nrow(x$tab)), cex = 0.6),
  worse.arg_x = list(x = x$worse_x, pch = 21, col = "white", bg = "tomato",
  cex = 2), worse.arg_y = list(x = x$worse_y, pch = 21, col = "white", bg =
  "tomato", cex = 2), better.arg_x = list(x = x$better_x, pch = 21, col =
  "white", bg = "mediumseagreen", cex = 2), better.arg_y = list(x =
  x$better_y, pch = 21, col = "white", bg = "mediumseagreen", cex = 2),
  auto.legend = TRUE, leg.arg = list(x = "topleft", bty = "n", xpd = NA,
  inset = c(-1.8, -0.2), ncol = 1, horiz = F, pch = 19, cex = 0.8, pt.cex =
  1.5), main.arg_x = list(main = "1st Stage"), main.arg_y = list(main =
  "2nd Stage"))
}
\arguments{
\item{x, y}{Objects of class 'SRU'. x is the SRU analsys from the 1st period (e.g. first trimester) and y from the 2nd period (e.g. second trimester). For \code{print.reclass} or \code{plot.reclass}, x is an object of class 'reclass'.}

\item{same}{Logical; If \code{TRUE}, compare the same units, with the same severity classes at two consecutive time periods (default). If \code{same = TRUE} and the ICUs do not match exactly in 'x' and 'y', there is a warning and non matching units are discarded from the analysis. If \code{FALSE}, it compares the same units, with the different severity classes within the same period. In this case, if the ICUs do not match exactly in 'x' and'y', the function will return an error.}

\item{plot}{Logical. If \code{TRUE} (default), plots a SMR vs. SRU scatter plot highlighting the ICUs which had their classification changed.}

\item{digits}{Integer indicating the number of decimal places to be used in the output.}

\item{compare}{The way one prefer to benchmark the ICUs: by "SRU" (default), "SMR" or "BOTH". If "BOTH", the ICUs will be ranked by their SRU.}

\item{decreasing}{Logical. Should the sort order of ICU's rank be increasing or decreasing?}

\item{complete.rank}{Logical. If \code{TRUE} (default), returns all ICUs ranked. If \code{FALSE}, returns only ICUs whose changed their efficiency classification ranked.}

\item{...}{Arguments to be passed to methods, such as \code{\link[graphics]{graphical parameters}} (see \code{\link[graphics]{par}}).}

\item{xlim_x, ylim_x}{Limits for x and y axis for 1st stage plot for \code{plot.reclass}.}

\item{xlim_y, ylim_y}{Limits for x and y axis for 2nd stage plot for \code{plot.reclass}.}

\item{xlab, ylab}{Labels of x and y axis for \code{plot.reclass}.}

\item{points.arg_x, points.arg_y}{List of arguments passed to \code{\link[graphics]{points}} for plotting points correponding to units' SMR and SRU in 1st and 2nd stage plots for \code{plot.reclass}.}

\item{med.arg_x, med.arg_y}{List of arguments passed to \code{\link[graphics]{abline}} for plotting lines corresponding to SRU and SMR medians in 1st and 2nd stage plots for \code{plot.reclass}.}

\item{tert.arg_x, tert.arg_y}{List of arguments passed to \code{\link[graphics]{abline}} for plotting lines corresponding to SRU and SMR tertiles in 1st and 2nd stage plots for \code{plot.reclass}.}

\item{text.arg_x, text.arg_y}{List of arguments passed to \code{\link[graphics]{text}} for plotting units labels in 1st and 2nd stage plots for \code{plot.reclass}.}

\item{worse.arg_x, worse.arg_y}{List of arguments passed to \code{\link[graphics]{points}} for plotting points correponding to units which got your rank worse in 1st and 2nd stage plots for \code{plot.reclass}.}

\item{better.arg_x, better.arg_y}{List of arguments passed to \code{\link[graphics]{points}} for plotting points correponding to units which got your rank better in 1st and 2nd stage plots for \code{plot.reclass}.}

\item{auto.legend}{Logical. If \code{TRUE}, it prints a legend with \code{leg.arg} arguments for \code{plot.reclass}.}

\item{leg.arg}{List of arguments passed to \code{\link[graphics]{legend}} for plotting legends corresponding to SRU and SMR medians and tertiles in 1st and 2nd stage plots for \code{plot.reclass}.}

\item{main.arg_x, main.arg_y}{List of arguments passed to \code{\link[graphics]{plot}} for overall title for 1st and 2nd stage plots for \code{plot.reclass}.}
}
\value{
\code{reclass} retunrs  a data.frame with the following columns:
\itemize{
\item \code{Unit} Names of the ICU.
\item\code{Admission} Number of admissions in each ICU.
\item \code{From} ICU's initial efficiency quadrant.
\item \code{To} ICU's final efficiency quadrant.
\item \code{SRU.1st} ICU's initial SRU estimate.
\item \code{SRU.2nd} ICU's final SRU estimate.
\item \code{SMR.1st} ICU's initial SMR estimate.
\item \code{SMR.2nd} ICU's final SMR estimate.
\item \code{Rank1} ICU's initial SRU (or SMR) rank.
\item \code{Rank2} ICU's final SRU (or SMR) rank.
}

\code{plot.reclass} returns a scatter plot with grpahical comparison of the two periods/stages with their respective medians and tertiles.
}
\description{
Compares ICU's (intensive care units) SRU with diferent severity classes or compares ICU's SRU at two diferents times. This comparison checks if the ICUs remains in the same quadrant after a time period, and highlights their rank changes over time.

\code{plot.reclass} Plots a SMR vs. SRU scatter plot with the ICUs which had their quadrant/rank classification changed.

\code{print.reclass} Prints a table with information about which ICUs changed from a classification to another.
}
\examples{

data(icu)
# A little editing
icu$Saps3DeathProbabilityStandardEquation <- icu$Saps3DeathProbabilityStandardEquation / 100
icu <- icu[-which(icu$los < 0 ),]

# Subseting the data for the 1st quarter
x <- droplevels(icu[which(format(as.Date(icu$UnitAdmissionDate),"\%m") \%in\% c("01","02","03")),])

# Subseting the data for the 2nd quarter
y <- droplevels(icu[which(format(as.Date(icu$UnitAdmissionDate),"\%m") \%in\% c("04","05","06")),])

# Running the SRU analysis for both quarters
FirstQ <- SRU(prob = x$Saps3DeathProbabilityStandardEquation, death = x$UnitDischargeName,
unit = x$Unit, los = x$los, score = x$Saps3Points, originals = TRUE, type = 1, plot = FALSE)
FirstQ

SecondQ <- SRU(prob = y$Saps3DeathProbabilityStandardEquation, death = y$UnitDischargeName,
unit = y$Unit, los = y$los, score = y$Saps3Points, originals = TRUE, type = 1, plot = FALSE)
SecondQ

z <- reclass(x = FirstQ, y = SecondQ, same = TRUE)
z
plot(z)

rm(icu, x, y, FirstQ, SecondQ, z)

}
\seealso{
\code{\link{SRU}}, \code{\link{SMR}}, \code{\link{funnel}}
}
\author{
Lunna Borges and Pedro Brasil
}
