% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{ecf}
\alias{ecf}
\title{Empirical characteristic function}
\usage{
ecf(t, smp)
}
\arguments{
\item{t}{mxd matrix where the function will be evaluated.}

\item{smp}{nxd matrix with sample size if size n.}
}
\value{
A complex vector of size m with the empirical
    characteristic function.
}
\description{
Empirical characteristic function of a d-dimensional random
variable. This function is evaluated at m vectors of size d.
}
\details{
This function must receive matrices or vectors. It is a wrapper
function that allows more general inputs.
}
\examples{
library(empichar)
t <- seq(-10, 10, 0.05)
X <- rnorm(150, mean = 1)
vals <- ecf(t, X)
plot(t, Re(vals), type = "l", main = "real part")
plot(t, Im(vals), type = "l", main = "imaginary part")

}
