% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmGrid-methods.R
\name{regrid}
\alias{regrid}
\title{Reconstruct a reference grid with a new transformation}
\usage{
regrid(object, transform = c("response", "mu", "unlink", "log", "none"),
  inv.log.lbl = "response", predict.type,
  bias.adjust = get_emm_option("back.bias.adj"), sigma, ...)
}
\arguments{
\item{object}{An object of class \code{emmGrid}}

\item{transform}{Character or logical value. If \code{"response"} or
\code{"mu"}, the inverse transformation is applied to the estimates in the
grid (but if there is both a link function and a response transformation,
\code{"mu"} back-transforms only the link part); if \code{"log"}, the
results are formulated as if the response had been \code{log}-transformed;
if \code{"none"}, predictions thereof are on the same scale as in 
\code{object}, and any internal transformation information is preserved. 
For compatibility with past versions, \code{transform} may also be logical;
\code{TRUE} is taken as \code{"response"}, and \code{FALSE} as 
\code{"none"}.}

\item{inv.log.lbl}{Character value. This applies only when \code{transform =
"log"}, and is used to label the predictions if subsequently summarized
with \code{type = "response"}.}

\item{predict.type}{Character value. If provided, the returned object is
updated with the given type to use by default by \code{summary.emmGrid}
(see \code{\link{update.emmGrid}}).  This may be useful if, for example,
when one specifies \code{transform = "log"} but desires summaries to be
produced by default on the response scale.}

\item{bias.adjust}{Logical value for whether to adjust for bias in
back-transforming (\code{transform = "response"}). This requires a value of 
\code{sigma} to exist in the object or be specified.}

\item{sigma}{Error SD assumed for bias correction (when 
\code{transform = "response"} and a transformation
is in effect). If not specified,
\code{object@misc$sigma} is used, and an error is thrown if it is not found.}

\item{...}{Ignored.}
}
\value{
An \code{emmGrid} object with the requested changes
}
\description{
The typical use of this function is to cause EMMs to be computed on
a different scale, e.g., the back-transformed scale rather than the 
linear-predictor scale. In other words, if you want back-transformed 
results, do you want to average and then back-transform, or 
back-transform and then average?
}
\details{
The \code{regrid} function reparameterizes an existing \code{ref.grid} so
that its \code{linfct} slot is the identity matrix and its \code{bhat} slot
consists of the estimates at the grid points. If \code{transform} is
\code{TRUE}, the inverse transform is applied to the estimates. Outwardly,
when \code{transform = "response"}, the result of \code{\link{summary.emmGrid}}
after applying \code{regrid} is identical to the summary of the original
object using \samp{type="response"}. But subsequent EMMs or
contrasts will be conducted on the new scale -- which is
the reason this function exists.

In cases where the
degrees of freedom depended on the linear function being estimated, the d.f.
from the reference grid are saved, and a kind of \dQuote{containment} method
is substituted in the returned object whereby the calculated d.f. for a new
linear function will be the minimum d.f. among those having nonzero
coefficients. This is kind of an \emph{ad hoc} method, and it can
over-estimate the degrees of freedom in some cases.
}
\note{
Another way to use \code{regrid} is to supply a \code{transform} 
  argument to \code{\link{ref_grid}} (either directly of indirectly via
  \code{\link{emmeans}}). This is often a simpler approach if the reference
  grid has not already been constructed.
}
\examples{
pigs.lm <- lm(log(conc) ~ source + factor(percent), data = pigs)

# This will yield EMMs as GEOMETRIC means of concentrations:
emmeans(pigs.lm, "source", type = "response")
# NOTE: pairs() of the above will be RATIOS of these results

# This will yield EMMs as ARITHMETIC means of concentrations:
emmeans(regrid(ref_grid(pigs.lm, transform = "response")), "source")
# Same thing, made simpler:
emmeans(pigs.lm, "source", transform = "response")
# NOTE: pairs() of the above will be DIFFERENCES of these results
}
