% Generated by roxygen2 (4.0.1): do not edit by hand
\name{modeling.procedure}
\alias{modeling.procedure}
\title{Setup a modeling procedure}
\usage{
modeling.procedure(method, param = list(), error.fun = NULL, fit.fun,
  predict.fun, vimp.fun)
}
\arguments{
\item{method}{The name of the modeling method. Only needed to identify
plug-in functions, i.e. if you supply them yourself there is no need to
set \code{method}.}

\item{param}{A list of model parameters. These will be fed to the fitting
  function after the dataset (\code{x} and \code{y} parameters). To tune a
  parameter, supply the candidate values in a vector or list.

  When tuning more than one parameter, all combinations of parameter values
  will be tested, if the elements of \code{param} are named. To manually
  specify which parameter value combinations to try, leave the the elements
  unnamed (see example 3 and 4).

  Parameters that should have vectors or lists as values, e.g. \code{trControl}
  when using
  \code{\link{emil.fit.caret}} to train caret models, must be wrapped in an
  additional list. That is, to set a parameter value to a list, but not tune it,
  make it a list of length 1 containing the list to be used (see example 6).}

\item{fit.fun}{The function to be used for model fitting.}

\item{predict.fun}{The function to be used for model prediction.}

\item{vimp.fun}{The function to be used for calculating or extracting variable
importance scores.}

\item{error.fun}{Performance measure used to evaluate modeling procedures
and to tune parameters. See \code{\link{error.fun}} for details.}
}
\value{
An object of class \code{modeling.procedure}.
}
\description{
A modeling procedure is an object containing all information necessary to
carry out and evaluate the performance of a predictive modeling task with
\code{\link{fit}}, \code{\link{tune}}, or \code{\link{evaluate.modeling}}.
To use an out-of-the box algorithm with default values, only the
\code{method} argument needs to be set. See \code{\link{emil}} for a
list of available methods. To deviate from the defaults, e.g. by tuning
variables or using a custom function for model fitting, set the appropriate
parameters as described below.
For a guide on how to implement a custom method see the documentaion page
\code{\link{emil.extensions}}.
}
\examples{
# 1: Fit linear discriminants without tuning any parameter,
# since it has none
modeling.procedure("lda")

# 2: Tune random forest's `mtry` parameter, with 3 possible values
modeling.procedure("randomForest", list(mtry = list(100, 250, 1000)))

# 3: Tune random forest's `mtry` and `maxnodes` parameters simultaneously,
# with 3 values each, testing all 9 possible combinations
modeling.procedure("randomForest", list(mtry = list(100, 250, 1000),
                                         maxnodes = list(5, 10, 25)))

# 4: Tune random forest's `mtry` and `maxnodes` parameters simultaneously,
# but only test 3 manually specified combinations of the two
modeling.procedure("randomForest", list(list(mtry = 100, maxnodes = 5),
                                    list(mtry = 250, maxnodes = 10),
                                    list(mtry = 1000, maxnodes = 25)))

# 5: Tune elastic net's `alpha` and `lambda` parameters. Since elastic net's
# fitting function can tune `lambda` internally in a more efficient way
# than the general framework is able to do, only tune `alpha` and pass all
# `lambda` values as a single argument.
modeling.procedure("glmnet", list(alpha = seq(0, 1, length.out=6),
                                   lambda = list(seq(0, 5, length.out=30))))

# 6: Train elastic nets using the caret package's model fitting framework
library(caret)
modeling.procedure("caret", list(method = "glmnet",
    trControl = list(trainControl(verboseIter = TRUE, classProbs = TRUE))))
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{evaluate.modeling}},
  \code{\link{fit}}, \code{\link{tune}},
  \code{\link[=predict.modeling.procedure]{predict}}, \code{\link{vimp}}
}

