% Generated by roxygen2 (4.0.1): do not edit by hand
\name{resample.mapply}
\alias{resample.mapply}
\title{Compare true response to resampled predictions}
\usage{
resample.mapply(fun, resample, true, pred, ...)
}
\arguments{
\item{fun}{Function to run.}

\item{resample}{Resampling scheme (see \code{\link{resample}}).}

\item{true}{True response vector.}

\item{pred}{Predictions, as returned from \code{\link{evaluate.modeling}}.}

\item{...}{Sent to \code{\link{mapply}}.}
}
\description{
This function can be used to compare a true response vector to predictions
returned from \code{\link{evaluate.modeling}}. For each fold, the correct
subset of the true response vector is extracted and fed to a given function
together with the matching predictions.
}
\examples{
proc <- modeling.procedure("lda")
ho <- resample("holdout", iris$Species, frac=1/3, nfold=4)
perf <- evaluate.modeling(proc, iris[-5], iris$Species, resample=ho)
confusion.tables <- resample.mapply(
    function(truth, prediction) table(truth, prediction$pred$pred),
    ho, iris$Species, pred=perf, SIMPLIFY=FALSE)
Reduce("+", confusion.tables)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}

