% Generated by roxygen2 (4.0.1): do not edit by hand
\name{image.resample}
\alias{image.crossval}
\alias{image.resample}
\title{Visualize resampling scheme}
\usage{
\method{image}{resample}(x, col, ...)

\method{image}{crossval}(x, col, ...)
}
\arguments{
\item{x}{Resampling scheme, as returned by \code{\link{resample}}.}

\item{col}{Color palette matching the values of \code{x}.
Can also be the response vector used to create the
scheme for automatic coloring.}

\item{...}{Sent to \code{\link{plot}}.}
}
\value{
Nothing, produces a plot.
}
\description{
Class specific extension to \code{\link{image}}.
}
\examples{
image(resample("holdout", 60, frac=1/3, nfold=20))

y <- gl(2, 30)
image(resample("crossval", y, nfold=3, nrep=8), col=y)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{resample}}
}

